/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchCoordinator;
import org.hibernate.search.mapper.orm.massindexing.impl.DelegatingMassIndexingFailureHandler;
import org.hibernate.search.mapper.orm.massindexing.impl.FailSafeMassIndexingFailureHandlerWrapper;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.LoggingMassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final String THREAD_NAME_PREFIX = "Mass indexing - ";
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedBackendSessionContext sessionContext;
    private final List<MassIndexingIndexedTypeGroup<?>> typeGroupsToIndex;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final PojoScopeWorkspace scopeWorkspace;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean mergeSegmentsOnFinish = false;
    private boolean dropAndCreateSchemaOnStart = false;
    private boolean purgeAtStart = true;
    private boolean mergeSegmentsAfterPurge = true;
    private int idFetchSize = 100;
    private Integer idLoadingTransactionTimeout;
    private MassIndexingFailureHandler failureHandler;
    private MassIndexingMonitor monitor;

    public MassIndexerImpl(HibernateOrmMassIndexingMappingContext mappingContext, Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> targetedIndexedTypes, DetachedBackendSessionContext sessionContext, PojoScopeSchemaManager scopeSchemaManager, PojoScopeWorkspace scopeWorkspace) {
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.typeGroupsToIndex = MassIndexingIndexedTypeGroup.disjoint(targetedIndexedTypes);
        this.scopeSchemaManager = scopeSchemaManager;
        this.scopeWorkspace = scopeWorkspace;
        log.debugf("Targets for mass indexing: %s", this.typeGroupsToIndex);
    }

    @Override
    public MassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = Math.min(numberOfThreads, this.typeGroupsToIndex.size());
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsOnFinish(boolean enable) {
        this.mergeSegmentsOnFinish = enable;
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsAfterPurge(boolean enable) {
        this.mergeSegmentsAfterPurge = enable;
        return this;
    }

    @Override
    public MassIndexer dropAndCreateSchemaOnStart(boolean enable) {
        this.dropAndCreateSchemaOnStart = enable;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean enable) {
        this.purgeAtStart = enable;
        return this;
    }

    @Override
    public MassIndexer transactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
        return this;
    }

    @Override
    public MassIndexer monitor(MassIndexingMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> start() {
        BatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(1, "Mass indexing - Coordinator");
        try {
            CompletableFuture completableFuture = Futures.runAsync((Runnable)coordinator, (ExecutorService)executor);
            return completableFuture;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        try {
            coordinator.run();
        }
        catch (Throwable t) {
            if (Thread.interrupted()) {
                InterruptedException exception = new InterruptedException();
                exception.addSuppressed(t);
                throw exception;
            }
            throw t;
        }
    }

    protected BatchCoordinator createCoordinator() {
        MassIndexingNotifier notifier = new MassIndexingNotifier(this.getOrCreateFailureHandler(), this.getOrCreateMonitor());
        return new BatchCoordinator(this.mappingContext, this.sessionContext, notifier, this.typeGroupsToIndex, this.scopeSchemaManager, this.scopeWorkspace, this.typesToIndexInParallel, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.mergeSegmentsOnFinish, this.dropAndCreateSchemaOnStart, this.purgeAtStart, this.mergeSegmentsAfterPurge, this.idFetchSize, this.idLoadingTransactionTimeout);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }

    @Override
    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }

    @Override
    public MassIndexer failureHandler(MassIndexingFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    private MassIndexingFailureHandler getOrCreateFailureHandler() {
        MassIndexingFailureHandler result = this.failureHandler;
        if (result == null) {
            result = new DelegatingMassIndexingFailureHandler(this.mappingContext.failureHandler());
        }
        result = new FailSafeMassIndexingFailureHandlerWrapper(result);
        return result;
    }

    private MassIndexingMonitor getOrCreateMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return new LoggingMassIndexingMonitor();
    }
}

