/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.projection.ProjectionCollector;

abstract class BaseSingleValuedProjectionCollector<E, V, R>
implements ProjectionCollector<E, V, Object, R> {
    protected BaseSingleValuedProjectionCollector() {
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final E createInitial() {
        return null;
    }

    @Override
    public final E accumulate(Object accumulated, E value) {
        if (accumulated != null) {
            throw QueryLog.INSTANCE.unexpectedMultiValuedField(accumulated, value);
        }
        return value;
    }

    @Override
    public final int size(Object accumulated) {
        return accumulated == null ? 0 : 1;
    }

    @Override
    public final E get(Object accumulated, int index) {
        return (E)accumulated;
    }

    @Override
    public final Object transform(Object accumulated, int index, V transformed) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Invalid index passed to " + String.valueOf(this) + ": " + index);
        }
        return transformed;
    }

    @Override
    public final Object transformAll(Object accumulated, FromDocumentValueConverter<? super E, ? extends V> converter, FromDocumentValueConvertContext context) {
        return converter.fromDocumentValue(accumulated, context);
    }
}

