/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.search.projection.spi.BuiltInProjectionCollectors;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public interface ProjectionCollector<E, V, A, R> {
    public static <V> Provider<V, V> nullable() {
        return BuiltInProjectionCollectors.nullable();
    }

    public static <V> Provider<V, Optional<V>> optional() {
        return BuiltInProjectionCollectors.optional();
    }

    public static <V, C> Provider<V, C> simple(Function<List<V>, C> converter) {
        return BuiltInProjectionCollectors.simple(converter);
    }

    public static <V> Provider<V, List<V>> list() {
        return BuiltInProjectionCollectors.list();
    }

    public static <V> Provider<V, Set<V>> set() {
        return BuiltInProjectionCollectors.set();
    }

    public static <V> Provider<V, SortedSet<V>> sortedSet() {
        return BuiltInProjectionCollectors.sortedSet();
    }

    public static <V> Provider<V, SortedSet<V>> sortedSet(Comparator<? super V> comparator) {
        return BuiltInProjectionCollectors.sortedSet(comparator);
    }

    public static <V> Provider<V, V[]> array(Class<? super V> componentType) {
        return BuiltInProjectionCollectors.array(componentType);
    }

    public A createInitial();

    public A accumulate(A var1, E var2);

    default public A accumulateAll(A accumulated, Collection<E> values) {
        for (E value : values) {
            accumulated = this.accumulate(accumulated, value);
        }
        return accumulated;
    }

    public int size(A var1);

    public E get(A var1, int var2);

    public A transform(A var1, int var2, V var3);

    default public A transformAll(A accumulated, FromDocumentValueConverter<? super E, ? extends V> converter, FromDocumentValueConvertContext context) {
        for (int i = 0; i < this.size(accumulated); ++i) {
            E initial = this.get(accumulated, i);
            V transformed = converter.fromDocumentValue(initial, context);
            accumulated = this.transform(accumulated, i, transformed);
        }
        return accumulated;
    }

    public R finish(A var1);

    default public R empty() {
        return this.finish(this.createInitial());
    }

    public static interface Provider<U, R> {
        public <T> ProjectionCollector<T, U, ?, R> get();

        public boolean isSingleValued();
    }
}

