/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SpatialWithinPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SpatialWithinPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.reference.predicate.SpatialPredicateFieldReference;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

class SpatialWithinPredicateFieldMoreStepImpl<SR>
implements SpatialWithinPredicateFieldMoreStep<SR, SpatialWithinPredicateFieldMoreStepImpl<SR>, SpatialWithinPredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private final CommonState<SR> commonState;
    private final List<String> fieldPaths;
    private final List<SearchPredicateBuilder> predicateBuilders;
    private Float fieldSetBoost;

    SpatialWithinPredicateFieldMoreStepImpl(CommonState<SR> commonState, List<String> fieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.fieldPaths = CollectionHelper.toImmutableList(fieldPaths);
        this.predicateBuilders = new ArrayList<SearchPredicateBuilder>(fieldPaths.size());
    }

    @Override
    public SpatialWithinPredicateFieldMoreStepImpl<SR> fields(String ... fieldPaths) {
        return new SpatialWithinPredicateFieldMoreStepImpl<SR>(this.commonState, Arrays.asList(fieldPaths));
    }

    @Override
    public SpatialWithinPredicateFieldMoreStepImpl<SR> fields(SpatialPredicateFieldReference<? super SR> ... fieldReferences) {
        ArrayList<String> fieldPaths = new ArrayList<String>(fieldReferences.length);
        for (SpatialPredicateFieldReference<SR> spatialPredicateFieldReference : fieldReferences) {
            fieldPaths.add(spatialPredicateFieldReference.absolutePath());
        }
        return new SpatialWithinPredicateFieldMoreStepImpl<SR>(this.commonState, fieldPaths);
    }

    @Override
    public SpatialWithinPredicateFieldMoreStepImpl<SR> boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public SpatialWithinPredicateOptionsStep<?> circle(GeoPoint center, double radius, DistanceUnit unit) {
        Contracts.assertNotNull((Object)center, (String)"center");
        Contracts.assertNotNull((Object)radius, (String)"radius");
        Contracts.assertNotNull((Object)((Object)unit), (String)"unit");
        return this.commonState.circle(center, radius, unit);
    }

    @Override
    public SpatialWithinPredicateOptionsStep<?> polygon(GeoPolygon polygon) {
        Contracts.assertNotNull((Object)polygon, (String)"polygon");
        return this.commonState.polygon(polygon);
    }

    @Override
    public SpatialWithinPredicateOptionsStep<?> boundingBox(GeoBoundingBox boundingBox) {
        Contracts.assertNotNull((Object)boundingBox, (String)"boundingBox");
        return this.commonState.boundingBox(boundingBox);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (SearchPredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    private void generateWithinCircleQueryBuilders(GeoPoint center, double radius, DistanceUnit unit) {
        SearchIndexScope<?> scope = this.commonState.scope();
        for (String fieldPath : this.fieldPaths) {
            SpatialWithinCirclePredicateBuilder predicateBuilder = scope.fieldQueryElement(fieldPath, PredicateTypeKeys.SPATIAL_WITHIN_CIRCLE);
            predicateBuilder.circle(center, radius, unit);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinPolygonQueryBuilders(GeoPolygon polygon) {
        SearchIndexScope<?> scope = this.commonState.scope();
        for (String fieldPath : this.fieldPaths) {
            SpatialWithinPolygonPredicateBuilder predicateBuilder = scope.fieldQueryElement(fieldPath, PredicateTypeKeys.SPATIAL_WITHIN_POLYGON);
            predicateBuilder.polygon(polygon);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinBoundingBoxQueryBuilders(GeoBoundingBox boundingBox) {
        SearchIndexScope<?> scope = this.commonState.scope();
        for (String fieldPath : this.fieldPaths) {
            SpatialWithinBoundingBoxPredicateBuilder predicateBuilder = scope.fieldQueryElement(fieldPath, PredicateTypeKeys.SPATIAL_WITHIN_BOUNDING_BOX);
            predicateBuilder.boundingBox(boundingBox);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    static class CommonState<SR>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<SR>, SpatialWithinPredicateFieldMoreStepImpl<SR>>
    implements SpatialWithinPredicateOptionsStep<CommonState<SR>> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        SpatialWithinPredicateOptionsStep<?> circle(GeoPoint center, double radius, DistanceUnit unit) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinCircleQueryBuilders(center, radius, unit);
            }
            return this;
        }

        SpatialWithinPredicateOptionsStep<?> polygon(GeoPolygon polygon) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinPolygonQueryBuilders(polygon);
            }
            return this;
        }

        SpatialWithinPredicateOptionsStep<?> boundingBox(GeoBoundingBox boundingBox) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinBoundingBoxQueryBuilders(boundingBox);
            }
            return this;
        }

        @Override
        protected CommonState<SR> thisAsS() {
            return this;
        }
    }
}

