/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.formatting", description="Logs related to parsing/formatting.")
@MessageLogger(projectCode="HSEARCH")
public interface FormattingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.formatting";
    public static final FormattingLog INSTANCE = (FormattingLog)LoggerFactory.make(FormattingLog.class, (String)"org.hibernate.search.formatting", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=502, value="Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s")
    public SearchException invalidPropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=503, value="Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s")
    public SearchException invalidBooleanPropertyValue(String var1, @Cause Exception var2);

    @Message(id=504, value="Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s")
    public SearchException invalidIntegerPropertyValue(String var1, @Cause Exception var2);

    @Message(id=505, value="Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s")
    public SearchException invalidLongPropertyValue(String var1, @Cause Exception var2);

    @Message(id=506, value="Invalid multi value: expected either a single value of the correct type, a Collection, or a String, and interpreting as a single value failed with the following exception. %1$s")
    public SearchException invalidMultiPropertyValue(String var1, @Cause Exception var2);

    @Message(id=516, value="Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.")
    public IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint var1, GeoPoint var2);

    @Message(id=547, value="Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s")
    public SearchException invalidBeanReferencePropertyValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=557, value="Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.")
    public SearchException unableToParseTemporal(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends TemporalAccessor> var1, String var2, DateTimeFormatter var3, @Cause Exception var4);

    @Message(id=558, value="Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s")
    public SearchException invalidNumberPropertyValue(@FormatWith(value=SimpleNameClassFormatter.class) Class<? extends Number> var1, String var2, @Cause Exception var3);

    @Message(id=559, value="Invalid string for type '%2$s': '%1$s'. %3$s")
    public SearchException invalidStringForType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, String var3, @Cause Exception var4);

    @Message(id=560, value="Invalid value for enum '%2$s': '%1$s'.")
    public SearchException invalidStringForEnum(String var1, @FormatWith(value=ClassFormatter.class) Class<? extends Enum<?>> var2, @Cause Exception var3);

    @Message(id=564, value="Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.")
    public SearchException unableToParseGeoPoint(String var1);
}

