/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.spi;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;

public final class IndexedEmbeddedPathTracker {
    private final IndexedEmbeddedDefinition definition;
    private final Map<String, Boolean> encounteredFieldPaths = new LinkedHashMap<String, Boolean>();

    public IndexedEmbeddedPathTracker(IndexedEmbeddedDefinition definition) {
        this.definition = definition;
    }

    public Set<String> uselessIncludePaths() {
        LinkedHashSet<String> uselessIncludePaths = new LinkedHashSet<String>();
        for (String path : this.definition.includePaths()) {
            Boolean included = this.encounteredFieldPaths.get(path);
            if (included != null && included.booleanValue()) continue;
            uselessIncludePaths.add(path);
        }
        return uselessIncludePaths;
    }

    public Set<String> encounteredFieldPaths() {
        return this.encounteredFieldPaths.keySet();
    }

    public void markAsEncountered(String relativePath, boolean included) {
        this.encounteredFieldPaths.merge(relativePath, included, (included1, included2) -> included1 != false || included2 != false);
    }
}

