/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.orchestration.spi;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.impl.Futures;

public final class SingletonTask {
    private final String name;
    private final Runnable runnable;
    private final Scheduler scheduler;
    private final FailureHandler failureHandler;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.IDLE);
    private volatile boolean needsRun;
    private volatile Future<?> nextExecutionFuture;
    private volatile CompletableFuture<?> completionFuture;

    public SingletonTask(String name, Worker worker, Scheduler scheduler, FailureHandler failureHandler) {
        this.name = name;
        this.runnable = new RunnableWrapper(worker);
        this.scheduler = scheduler;
        this.failureHandler = failureHandler;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[status=" + this.status + ", needsRun=" + this.needsRun + ", nextExecutionFuture=" + this.nextExecutionFuture + "]";
    }

    public void ensureScheduled() {
        this.needsRun = true;
        if (!this.status.compareAndSet(Status.IDLE, Status.SCHEDULED)) {
            return;
        }
        try {
            if (this.completionFuture == null) {
                this.completionFuture = new CompletableFuture();
            }
            this.nextExecutionFuture = this.scheduler.schedule(this.runnable);
        }
        catch (Throwable e) {
            try {
                CompletableFuture<?> future = this.completionFuture;
                this.completionFuture = null;
                this.status.set(Status.IDLE);
                future.completeExceptionally(e);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public CompletableFuture<?> completion() {
        CompletableFuture<?> future = this.completionFuture;
        if (future == null) {
            return CompletableFuture.completedFuture(null);
        }
        return future;
    }

    public void stop() {
        this.cancelIfNotNull(this.nextExecutionFuture);
        this.nextExecutionFuture = null;
        this.cancelIfNotNull(this.completionFuture);
    }

    private void cancelIfNotNull(Future<?> futureToCancel) {
        if (futureToCancel != null) {
            futureToCancel.cancel(false);
        }
    }

    private class RunnableWrapper
    implements Runnable {
        private final Worker worker;
        private final BiFunction<Object, Throwable, Object> workFinishedHandler = Futures.handler(this::onWorkFinished);

        public RunnableWrapper(Worker worker) {
            this.worker = worker;
        }

        @Override
        public void run() {
            SingletonTask.this.needsRun = false;
            SingletonTask.this.nextExecutionFuture = null;
            try {
                this.worker.work().handle(this.workFinishedHandler);
            }
            catch (Throwable e) {
                this.onWorkFinished(null, e);
            }
        }

        private Void onWorkFinished(Object ignored, Throwable throwable) {
            if (throwable != null) {
                this.handleUnexpectedFailure(throwable, "Executing task '" + SingletonTask.this.name + "'");
            }
            try {
                this.afterRun();
            }
            catch (Throwable e) {
                this.handleUnexpectedFailure(e, "Handling post-execution in task '" + SingletonTask.this.name + "'");
            }
            return null;
        }

        private void afterRun() {
            if (!SingletonTask.this.needsRun) {
                try {
                    this.worker.complete();
                }
                catch (Throwable e) {
                    this.handleUnexpectedFailure(e, "Calling worker.complete() in task '" + SingletonTask.this.name + "'");
                }
                CompletableFuture justFinishedExecutionFuture = SingletonTask.this.completionFuture;
                SingletonTask.this.completionFuture = null;
                justFinishedExecutionFuture.complete(null);
            }
            SingletonTask.this.status.set(Status.IDLE);
            if (SingletonTask.this.needsRun) {
                SingletonTask.this.ensureScheduled();
            }
        }

        private void handleUnexpectedFailure(Throwable throwable, String failingOperation) {
            FailureContext.Builder contextBuilder = FailureContext.builder();
            contextBuilder.throwable(throwable);
            contextBuilder.failingOperation(failingOperation);
            SingletonTask.this.failureHandler.handle(contextBuilder.build());
        }
    }

    private static enum Status {
        IDLE,
        SCHEDULED;

    }

    public static interface Scheduler {
        public Future<?> schedule(Runnable var1);
    }

    public static interface Worker {
        public CompletableFuture<?> work();

        public void complete();
    }
}

