/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.util.Arrays;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.VectorUtil;
import org.hibernate.search.backend.lucene.logging.impl.IndexingLog;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.util.common.AssertionFailure;

public class LuceneByteVectorCodec
extends AbstractLuceneVectorFieldCodec<byte[]> {
    public LuceneByteVectorCodec(VectorSimilarityFunction vectorSimilarity, int dimension, Storage storage, Indexing indexing, byte[] indexNullAsValue, HibernateSearchKnnVectorsFormat knnVectorsFormat) {
        super(vectorSimilarity, dimension, storage, indexing, indexNullAsValue, knnVectorsFormat, VectorSimilarityFunction.COSINE.equals((Object)vectorSimilarity) ? LuceneByteVectorCodec::cosineCheck : LuceneByteVectorCodec::noop);
    }

    @Override
    public byte[] decode(IndexableField field) {
        return field.binaryValue().bytes;
    }

    @Override
    public byte[] raw(IndexableField field) {
        return this.decode(field);
    }

    @Override
    public Class<byte[]> encodedType() {
        return byte[].class;
    }

    @Override
    protected byte[] toByteArray(byte[] value) {
        return value;
    }

    @Override
    protected IndexableField createIndexField(String absoluteFieldPath, byte[] value) {
        return new KnnByteVectorField(absoluteFieldPath, value, this.fieldType);
    }

    @Override
    protected VectorEncoding vectorEncoding() {
        return VectorEncoding.BYTE;
    }

    @Override
    public Class<?> vectorElementsType() {
        return Byte.TYPE;
    }

    @Override
    public float similarityDistanceToScore(float distance) {
        switch (this.vectorSimilarity) {
            case EUCLIDEAN: {
                return 1.0f / (1.0f + distance * distance);
            }
            case DOT_PRODUCT: {
                return 0.5f + distance / (float)(this.getConfiguredDimensions() * 32768);
            }
            case COSINE: {
                return (1.0f + distance) / 2.0f;
            }
            case MAXIMUM_INNER_PRODUCT: {
                return VectorUtil.scaleMaxInnerProductScore((float)distance);
            }
        }
        throw new AssertionFailure("Unknown similarity function: " + String.valueOf(this.vectorSimilarity));
    }

    private static void cosineCheck(byte[] vector) {
        for (byte b : vector) {
            if (b == 0) continue;
            return;
        }
        throw IndexingLog.INSTANCE.vectorCosineZeroMagnitudeNotAcceptable(Arrays.toString(vector));
    }

    private static void noop(byte[] vector) {
    }
}

