/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneMultivaluedTermsAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LocalAggregationExtractContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LocalAggregationRequestContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LongBucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneCountDocumentAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneNumericTermsAggregation<F, E extends Number, K, V, R>
extends AbstractLuceneMultivaluedTermsAggregation<F, E, K, V, R> {
    private final LuceneNumericDomain<E> numericDomain;
    private final Comparator<E> termComparator;
    private final Function<E, V> decoder;
    private CollectorKey<NumericTermsCollector, TermResults> collectorKey;

    private LuceneNumericTermsAggregation(Builder<F, E, K, V, R> builder) {
        super(builder);
        this.numericDomain = builder.codec.getDomain();
        this.termComparator = this.numericDomain.createComparator();
        this.decoder = builder.decoder;
    }

    @Override
    public LuceneSearchAggregation.Extractor<Map<K, R>> request(AggregationRequestContext context) {
        NestedDocsProvider nestedDocsProvider = this.createNestedDocsProvider(context);
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromLongField(this.absoluteFieldPath, nestedDocsProvider);
        LocalAggregationRequestContext localAggregationContext = new LocalAggregationRequestContext(context);
        LuceneSearchAggregation.Extractor extractor = this.aggregation.request(localAggregationContext);
        CollectorFactory<NumericTermsCollector, TermResults, NumericTermsCollectorManager> termsCollectorFactory = NumericTermsCollectorFactory.instance(source, localAggregationContext.localCollectorFactories());
        context.requireCollector(termsCollectorFactory);
        this.collectorKey = termsCollectorFactory.getCollectorKey();
        return new LuceneNumericTermsAggregationExtractor(extractor);
    }

    private static class Builder<F, E extends Number, K, V, R>
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractBuilder<F, E, K, V, R> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final Function<E, V> decoder;

        private Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, LuceneSearchAggregation<R> aggregation, ProjectionConverter<V, ? extends K> fromFieldValueConverter, Function<E, V> decoder) {
            super(scope, field, aggregation, fromFieldValueConverter);
            this.codec = codec;
            this.decoder = decoder;
        }

        private Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, LuceneSearchAggregation<R> aggregation, ProjectionConverter<V, ? extends K> fromFieldValueConverter, Function<E, V> decoder, BucketOrder order, int minDocCount, int maxTermCount) {
            super(scope, field, aggregation, fromFieldValueConverter, order, minDocCount, maxTermCount);
            this.codec = codec;
            this.decoder = decoder;
        }

        @Override
        public LuceneNumericTermsAggregation<F, E, K, V, R> build() {
            return new LuceneNumericTermsAggregation(this);
        }

        public <T> TermsAggregationBuilder<K, T> withValue(SearchAggregation<T> aggregation) {
            return new Builder<F, E, K, V, T>(this.codec, this.scope, this.field, LuceneSearchAggregation.from(this.scope, aggregation), this.fromFieldValueConverter, this.decoder, this.order, this.minDocCount, this.maxTermCount);
        }
    }

    private class LuceneNumericTermsAggregationExtractor
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractExtractor {
        private LuceneNumericTermsAggregationExtractor(LuceneSearchAggregation.Extractor<R> extractor) {
            super(extractor);
        }

        @Override
        protected TermResults termResults(AggregationExtractContext context) throws IOException {
            return context.getCollectorResults(LuceneNumericTermsAggregation.this.collectorKey);
        }

        Comparator<E> getAscendingTermComparator() {
            return LuceneNumericTermsAggregation.this.termComparator;
        }

        V termToFieldValue(E key) {
            return LuceneNumericTermsAggregation.this.decoder.apply(key);
        }

        List<Bucket<E, R>> getTopBuckets(AggregationExtractContext context) throws IOException {
            TermResults termResults = context.getCollectorResults(LuceneNumericTermsAggregation.this.collectorKey);
            LocalAggregationExtractContext localContext = new LocalAggregationExtractContext(context);
            List<LongBucket> counts = termResults.counts(LuceneNumericTermsAggregation.this.order, LuceneNumericTermsAggregation.this.maxTermCount, LuceneNumericTermsAggregation.this.minDocCount);
            ArrayList buckets = new ArrayList();
            for (LongBucket bucket : counts) {
                localContext.setResults(this.prepareResults(bucket, termResults));
                buckets.add(new Bucket(LuceneNumericTermsAggregation.this.numericDomain.sortedDocValueToTerm(bucket.termOrd()), bucket.count(), this.extractor.extract(localContext)));
            }
            return buckets;
        }

        Set<E> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
            TreeSet collectedTerms = new TreeSet(descending ? LuceneNumericTermsAggregation.this.termComparator.reversed() : LuceneNumericTermsAggregation.this.termComparator);
            for (LeafReaderContext leaf : reader.leaves()) {
                LeafReader atomicReader = leaf.reader();
                SortedNumericDocValues docValues = atomicReader.getSortedNumericDocValues(LuceneNumericTermsAggregation.this.absoluteFieldPath);
                if (docValues == null) continue;
                while (docValues.nextDoc() != Integer.MAX_VALUE) {
                    for (int i = 0; i < docValues.docValueCount(); ++i) {
                        Object term = LuceneNumericTermsAggregation.this.numericDomain.sortedDocValueToTerm(docValues.nextValue());
                        collectedTerms.add(term);
                        if (collectedTerms.size() <= limit) continue;
                        collectedTerms.remove(collectedTerms.last());
                    }
                }
            }
            return collectedTerms;
        }
    }

    private static class CountBuilder<F, E extends Number, K, V>
    extends Builder<F, E, K, V, Long> {
        private CountBuilder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, ProjectionConverter<V, ? extends K> fromFieldValueConverter, Function<E, V> decoder) {
            super(codec, scope, field, LuceneSearchAggregation.from(scope, LuceneCountDocumentAggregation.factory().create(scope, field).builder().build()), fromFieldValueConverter, decoder);
        }
    }

    private static class TypeSelector<F, E extends Number>
    extends AbstractLuceneMultivaluedTermsAggregation.AbstractTypeSelector<F> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        private TypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.codec = codec;
        }

        @Override
        public <K> Builder<F, ?, K, ?, Long> type(Class<K> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new CountBuilder(this.codec, this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, (EventContextProvider)this.field), Function.identity());
            }
            return new CountBuilder(this.codec, this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, (EventContextProvider)this.field), this.codec::decode);
        }
    }

    public static class Factory<F, E extends Number>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<TermsAggregationBuilder.TypeSelector, F, AbstractLuceneNumericFieldCodec<F, E>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public TermsAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TypeSelector((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }
}

