/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.aggregation.impl.RootAggregationRequestContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcherImpl;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.query.spi.QueryParameters;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneSearchQueryBuilder<H>
implements SearchQueryBuilder<H>,
LuceneSearchSortCollector {
    private final LuceneWorkFactory workFactory;
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneSearchQueryIndexScope<?, ?> scope;
    private final BackendSessionContext sessionContext;
    private final Set<String> routingKeys;
    private final SearchLoadingContextBuilder<?, ?> loadingContextBuilder;
    private final LuceneSearchProjection<H> rootProjection;
    private LuceneSearchPredicate lucenePredicate;
    private List<SortField> sortFields;
    private List<LuceneSearchSort> luceneSearchSorts;
    private Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private Long timeout;
    private TimeUnit timeUnit;
    private boolean exceptionOnTimeout;
    private Long totalHitCountThreshold;
    private LuceneAbstractSearchHighlighter globalHighlighter;
    private final Map<String, LuceneAbstractSearchHighlighter> namedHighlighters = new HashMap<String, LuceneAbstractSearchHighlighter>();
    private final QueryParameters parameters = new QueryParameters();

    public LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneSyncWorkOrchestrator queryOrchestrator, LuceneSearchQueryIndexScope<?, ?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<H> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public void predicate(SearchPredicate predicate) {
        this.lucenePredicate = LuceneSearchPredicate.from(this.scope, predicate);
    }

    public void sort(SearchSort sort) {
        if (this.luceneSearchSorts == null) {
            this.luceneSearchSorts = new ArrayList<LuceneSearchSort>();
        }
        this.luceneSearchSorts.add(LuceneSearchSort.from(this.scope, sort));
    }

    public <A> void aggregation(AggregationKey<A> key, SearchAggregation<A> aggregation) {
        LuceneSearchAggregation<A> previous;
        LuceneSearchAggregation<A> casted = LuceneSearchAggregation.from(this.scope, aggregation);
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, casted)) != null) {
            throw QueryLog.INSTANCE.duplicateAggregationKey(key);
        }
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    public void totalHitCountThreshold(long totalHitCountThreshold) {
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public void highlighter(SearchHighlighter queryHighlighter) {
        this.globalHighlighter = LuceneAbstractSearchHighlighter.from(this.scope, queryHighlighter);
    }

    public void highlighter(String highlighterName, SearchHighlighter highlighter) {
        if (highlighterName == null || highlighterName.trim().isEmpty()) {
            throw QueryLog.INSTANCE.highlighterNameCannotBeBlank();
        }
        if (this.namedHighlighters.put(highlighterName, LuceneAbstractSearchHighlighter.from(this.scope, highlighter)) != null) {
            throw QueryLog.INSTANCE.highlighterWithTheSameNameCannotBeAdded(highlighterName);
        }
    }

    public void param(String parameterName, Object value) {
        this.parameters.add(parameterName, value);
    }

    @Override
    public void collectSortField(SortField sortField) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(sortField);
    }

    @Override
    public void collectSortFields(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(sortFields.length);
        }
        Collections.addAll(this.sortFields, sortFields);
    }

    @Override
    public PredicateRequestContext toPredicateRequestContext(String absoluteNestedPath) {
        return PredicateRequestContext.withSession(this.scope, this.sessionContext, this.routingKeys, this.parameters).withNestedPath(absoluteNestedPath);
    }

    public LuceneSearchQuery<H> build() {
        Map<AggregationKey<?>, LuceneSearchAggregation.Extractor<?>> aggregationExtractors;
        Query filter;
        Query luceneQuery = this.lucenePredicate.toQuery(PredicateRequestContext.withSession(this.scope, this.sessionContext, this.routingKeys, this.parameters));
        SearchLoadingContext loadingContext = this.loadingContextBuilder.build();
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(luceneQuery, BooleanClause.Occur.MUST);
        if (this.scope.hasNestedDocuments()) {
            luceneQueryBuilder.add(Queries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        }
        if (!this.routingKeys.isEmpty()) {
            Query routingKeysQuery = Queries.anyTerm(MetadataFields.routingKeyFieldName(), this.routingKeys);
            luceneQueryBuilder.add(routingKeysQuery, BooleanClause.Occur.FILTER);
        }
        if ((filter = this.scope.filterOrNull(this.sessionContext.tenantIdentifier())) != null) {
            luceneQueryBuilder.add(filter, BooleanClause.Occur.FILTER);
        }
        BooleanQuery definitiveLuceneQuery = luceneQueryBuilder.build();
        if (this.luceneSearchSorts != null) {
            for (LuceneSearchSort luceneSearchSort : this.luceneSearchSorts) {
                luceneSearchSort.toSortFields(this);
            }
        }
        Sort luceneSort = null;
        if (this.sortFields != null && !this.sortFields.isEmpty()) {
            luceneSort = new Sort(this.sortFields.toArray(new SortField[0]));
        }
        LuceneSearchQueryRequestContext requestContext = new LuceneSearchQueryRequestContext(this.scope, this.sessionContext, loadingContext, (Query)definitiveLuceneQuery, luceneSort, this.routingKeys, this.parameters);
        LuceneAbstractSearchHighlighter resolvedGlobalHighlighter = this.globalHighlighter == null ? null : this.globalHighlighter.withFallbackDefaults();
        HashMap<String, LuceneAbstractSearchHighlighter> resolvedNamedHighlighters = new HashMap<String, LuceneAbstractSearchHighlighter>();
        if (resolvedGlobalHighlighter != null) {
            for (Map.Entry<String, LuceneAbstractSearchHighlighter> entry : this.namedHighlighters.entrySet()) {
                resolvedNamedHighlighters.put(entry.getKey(), entry.getValue().withFallback(resolvedGlobalHighlighter));
            }
        } else {
            for (Map.Entry<String, LuceneAbstractSearchHighlighter> entry : this.namedHighlighters.entrySet()) {
                resolvedNamedHighlighters.put(entry.getKey(), entry.getValue().withFallbackDefaults());
            }
        }
        ExtractionRequirements.Builder extractionRequirementsBuilder = new ExtractionRequirements.Builder();
        ProjectionRequestContext projectionRequestContext = new ProjectionRequestContext(extractionRequirementsBuilder, resolvedGlobalHighlighter, resolvedNamedHighlighters, this.parameters);
        LuceneSearchProjection.Extractor<?, H> rootExtractor = this.rootProjection.request(projectionRequestContext);
        if (this.aggregations != null) {
            aggregationExtractors = new LinkedHashMap();
            RootAggregationRequestContext aggregationRequestContext = new RootAggregationRequestContext(this.scope, this.sessionContext, this.routingKeys, extractionRequirementsBuilder, this.parameters);
            for (Map.Entry<AggregationKey<?>, LuceneSearchAggregation<?>> entry : this.aggregations.entrySet()) {
                aggregationExtractors.put(entry.getKey(), entry.getValue().request(aggregationRequestContext));
            }
        } else {
            aggregationExtractors = Collections.emptyMap();
        }
        ExtractionRequirements extractionRequirements = extractionRequirementsBuilder.build();
        TimeoutManager timeoutManager = this.scope.createTimeoutManager(this.timeout, this.timeUnit, this.exceptionOnTimeout);
        LuceneSearcherImpl<H> searcher = new LuceneSearcherImpl<H>(requestContext, rootExtractor, aggregationExtractors, extractionRequirements, timeoutManager);
        return new LuceneSearchQueryImpl(this.queryOrchestrator, this.workFactory, this.scope, this.sessionContext, loadingContext, this.routingKeys, timeoutManager, (Query)definitiveLuceneQuery, luceneSort, searcher, this.totalHitCountThreshold);
    }
}

