/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;

public class LuceneFieldProjection<F, V, P, T>
extends AbstractLuceneProjection<P> {
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final String requiredContextAbsoluteFieldPath;
    private final Function<IndexableField, T> decodeFunction;
    private final ProjectionConverter<T, ? extends V> converter;
    private final ProjectionCollector.Provider<V, P> collectorProvider;

    private LuceneFieldProjection(Builder<F, V, T> builder, ProjectionCollector.Provider<V, P> collectorProvider) {
        this(builder.scope, builder.field, builder.decodeFunction, builder.converter, collectorProvider);
    }

    LuceneFieldProjection(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, Function<IndexableField, T> decodeFunction, ProjectionConverter<T, ? extends V> converter, ProjectionCollector.Provider<V, P> collectorProvider) {
        super(scope);
        this.absoluteFieldPath = field.absolutePath();
        this.nestedDocumentPath = field.nestedDocumentPath();
        this.requiredContextAbsoluteFieldPath = collectorProvider.isSingleValued() ? field.closestMultiValuedParentAbsolutePath() : null;
        this.decodeFunction = decodeFunction;
        this.converter = converter;
        this.collectorProvider = collectorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", collectorProvider=" + String.valueOf(this.collectorProvider) + "]";
    }

    public ValueFieldExtractor<?> request(ProjectionRequestContext context) {
        context.checkValidField(this.absoluteFieldPath);
        if (!context.projectionCardinalityCorrectlyAddressed(this.requiredContextAbsoluteFieldPath)) {
            throw QueryLog.INSTANCE.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        context.requireStoredField(this.absoluteFieldPath, this.nestedDocumentPath);
        return new ValueFieldExtractor(context.absoluteCurrentNestedFieldPath(), this.collectorProvider.get());
    }

    private static class Builder<F, V, T>
    extends AbstractLuceneProjection.AbstractBuilder<V>
    implements FieldProjectionBuilder<V> {
        private final Function<IndexableField, T> decodeFunction;
        private final LuceneSearchIndexValueFieldContext<F> field;
        private final ProjectionConverter<T, ? extends V> converter;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, Function<IndexableField, T> decodeFunction, ProjectionConverter<T, ? extends V> converter) {
            super(scope);
            this.decodeFunction = decodeFunction;
            this.field = field;
            this.converter = converter;
        }

        public <P> SearchProjection<P> build(ProjectionCollector.Provider<V, P> collectorProvider) {
            if (collectorProvider.isSingleValued() && this.field.multiValued()) {
                throw QueryLog.INSTANCE.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new LuceneFieldProjection(this, collectorProvider);
        }
    }

    private class ValueFieldExtractor<A>
    implements LuceneSearchProjection.Extractor<A, P> {
        private final String contextAbsoluteFieldPath;
        private final ProjectionCollector<T, V, A, P> collector;

        public ValueFieldExtractor(String contextAbsoluteFieldPath, ProjectionCollector<T, V, A, P> collector) {
            this.collector = collector;
            this.contextAbsoluteFieldPath = contextAbsoluteFieldPath;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[absoluteFieldPath=" + LuceneFieldProjection.this.absoluteFieldPath + ", collector=" + String.valueOf(this.collector) + "]";
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            return new StoredFieldValues(this.collector, context.collectorExecutionContext());
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            Object transformedData = this.collector.transformAll(extractedData, LuceneFieldProjection.this.converter.delegate(), convertContext);
            return this.collector.finish(transformedData);
        }

        private class StoredFieldValues
        extends AbstractNestingAwareAccumulatingValues<T, A> {
            private final StoredFieldsValuesDelegate delegate;

            public StoredFieldValues(ProjectionCollector<T, V, A, P> collector, TopDocsDataCollectorExecutionContext context) {
                super(ValueFieldExtractor.this.contextAbsoluteFieldPath, LuceneFieldProjection.this.nestedDocumentPath, collector, context);
                this.delegate = context.storedFieldsValuesDelegate();
            }

            @Override
            protected DocIdSetIterator doContext(LeafReaderContext context) {
                return null;
            }

            @Override
            protected A accumulate(A accumulated, int docId) {
                Document document = this.delegate.get(docId);
                for (IndexableField field : document.getFields()) {
                    if (!field.name().equals(LuceneFieldProjection.this.absoluteFieldPath)) continue;
                    Object decoded = LuceneFieldProjection.this.decodeFunction.apply(field);
                    accumulated = this.collector.accumulate(accumulated, decoded);
                }
                return accumulated;
            }
        }
    }

    private static class TypeSelector<F, E>
    implements FieldProjectionBuilder.TypeSelector {
        private final LuceneFieldCodec<F, E> codec;
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<F> field;

        private TypeSelector(LuceneFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <V> Builder<F, V, ?> type(Class<V> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new Builder(this.scope, this.field, this.codec::raw, this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field));
            }
            return new Builder(this.scope, this.field, this.codec::decode, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F, E>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<FieldProjectionBuilder.TypeSelector, F, LuceneFieldCodec<F, E>> {
        public Factory(LuceneFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?, ?> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            field.nestedPathHierarchy();
            return new TypeSelector(this.codec, scope, field);
        }
    }
}

