/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.schema.management.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.schema.management.LuceneIndexSchemaExport;

public class LuceneIndexSchemaExportImpl
implements LuceneIndexSchemaExport {
    private static final byte[] EXPORT_MESSAGE = "The Lucene backend does not support exporting the schema.".getBytes(StandardCharsets.UTF_8);
    private final String indexName;

    public LuceneIndexSchemaExportImpl(String indexName) {
        this.indexName = indexName;
    }

    public String indexName() {
        return this.indexName;
    }

    public void toFiles(Path targetDirectory) {
        try (OutputStream outputStream = Files.newOutputStream(Files.createDirectories(targetDirectory, new FileAttribute[0]).resolve("no-schema.txt"), new OpenOption[0]);){
            outputStream.write(EXPORT_MESSAGE);
        }
        catch (IOException e) {
            throw LuceneMiscLog.INSTANCE.unableToExportSchema(this.indexName, e.getMessage(), e);
        }
    }
}

