/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.util.function.BiConsumer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.hibernate.search.backend.lucene.logging.impl.ConfigurationLog;

class IndexWriterSettingValue<T> {
    private final String settingName;
    private final T value;
    private final BiConsumer<IndexWriterConfig, T> writerSettingApplier;
    private final BiConsumer<LogByteSizeMergePolicy, T> mergePolicySettingApplier;

    IndexWriterSettingValue(String settingName, T value, BiConsumer<IndexWriterConfig, T> writerSettingApplier, BiConsumer<LogByteSizeMergePolicy, T> mergePolicySettingApplier) {
        this.settingName = settingName;
        this.value = value;
        this.writerSettingApplier = writerSettingApplier;
        this.mergePolicySettingApplier = mergePolicySettingApplier;
    }

    public String toString() {
        return "<" + this.settingName + "=" + String.valueOf(this.value) + ">";
    }

    public void applySetting(IndexWriterConfig writerConfig) {
        try {
            this.writerSettingApplier.accept(writerConfig, (IndexWriterConfig)this.value);
        }
        catch (RuntimeException e) {
            throw ConfigurationLog.INSTANCE.illegalIndexWriterSetting(this.settingName, this.value, e.getMessage(), e);
        }
    }

    public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy) {
        try {
            this.mergePolicySettingApplier.accept(logByteSizeMergePolicy, (LogByteSizeMergePolicy)this.value);
        }
        catch (RuntimeException e) {
            throw ConfigurationLog.INSTANCE.illegalMergePolicySetting(this.settingName, this.value, e.getMessage(), e);
        }
    }
}

