/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.util.PriorityQueue;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermCollectorSegmentValue;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LongBucket;

public class TermResults {
    static final TermResults EMPTY = new TermResults(new CollectorKey[0], new CollectorManager[0]);
    private final CollectorKey<?, ?>[] collectorKeys;
    private final CollectorManager<Collector, ?>[] managers;
    private final LongObjectHashMap<LongBucket> buckets = new LongObjectHashMap();

    TermResults(CollectorKey<?, ?>[] collectorKeys, CollectorManager<Collector, ?>[] managers) {
        this.collectorKeys = collectorKeys;
        this.managers = managers;
    }

    public List<LongBucket> counts(BucketOrder order, int topN, int minDocCount) {
        int size = Math.min(topN, this.buckets.size());
        HibernateSearchBucketOrderQueue pq = new HibernateSearchBucketOrderQueue(order, size);
        this.buckets.forEach((key, value) -> {
            if (value.count >= (long)minDocCount) {
                pq.insertWithOverflow(value);
            }
        });
        LinkedList<LongBucket> results = new LinkedList<LongBucket>();
        while (pq.size() != 0) {
            LongBucket popped = (LongBucket)pq.pop();
            results.add(0, popped);
        }
        return results;
    }

    void add(LongObjectHashMap<TermCollectorSegmentValue> segmentValues) {
        for (LongObjectCursor segment : segmentValues) {
            LongBucket bucket = (LongBucket)this.buckets.get(segment.key);
            if (bucket == null) {
                bucket = new LongBucket(segment.key, ((TermCollectorSegmentValue)segment.value).collectors, ((TermCollectorSegmentValue)segment.value).count);
                this.buckets.put(segment.key, (Object)bucket);
                continue;
            }
            bucket.add(((TermCollectorSegmentValue)segment.value).collectors, ((TermCollectorSegmentValue)segment.value).count);
        }
    }

    public void merge(LongObjectHashMap<LongBucket> values) {
        for (LongObjectCursor toadd : values) {
            LongBucket bucket = (LongBucket)this.buckets.get(toadd.key);
            if (bucket == null) {
                bucket = new LongBucket(toadd.key, ((LongBucket)toadd.value).collectors, ((LongBucket)toadd.value).count);
                this.buckets.put(toadd.key, (Object)bucket);
                continue;
            }
            bucket.add((LongBucket)toadd.value);
        }
    }

    public CollectorKey<?, ?>[] collectorKeys() {
        return this.collectorKeys;
    }

    public CollectorManager<Collector, ?>[] collectorManagers() {
        return this.managers;
    }

    private static class HibernateSearchBucketOrderQueue
    extends PriorityQueue<LongBucket> {
        private final Comparator<LongBucket> comparator;

        public HibernateSearchBucketOrderQueue(BucketOrder order, int maxSize) {
            super(maxSize);
            this.comparator = order.toLongBucketComparator();
        }

        protected boolean lessThan(LongBucket t1, LongBucket t2) {
            return this.comparator.compare(t1, t2) > 0;
        }
    }
}

