/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneNumericTermsAggregation<F, E extends Number, K, V>
extends AbstractLuceneFacetsBasedTermsAggregation<F, E, K, V> {
    private final LuceneNumericDomain<E> numericDomain;
    private final Comparator<E> termComparator;
    private final Function<E, V> decoder;

    private LuceneNumericTermsAggregation(Builder<F, E, K, V> builder) {
        super(builder);
        this.numericDomain = builder.codec.getDomain();
        this.termComparator = this.numericDomain.createComparator();
        this.decoder = builder.decoder;
    }

    @Override
    protected LuceneSearchAggregation.Extractor<Map<K, Long>> extractor(AggregationRequestContext context) {
        return new LuceneNumericTermsAggregationExtractor();
    }

    private static class Builder<F, E extends Number, K, V>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<F, E, K, V> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final Function<E, V> decoder;

        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, ProjectionConverter<V, ? extends K> fromFieldValueConverter, Function<E, V> decoder) {
            super(scope, field, fromFieldValueConverter);
            this.codec = codec;
            this.decoder = decoder;
        }

        @Override
        public LuceneNumericTermsAggregation<F, E, K, V> build() {
            return new LuceneNumericTermsAggregation(this);
        }
    }

    private class LuceneNumericTermsAggregationExtractor
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractExtractor {
        private LuceneNumericTermsAggregationExtractor() {
        }

        @Override
        FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider, int limit) throws IOException {
            Facets facetCounts = LuceneNumericTermsAggregation.this.numericDomain.createTermsFacetCounts(LuceneNumericTermsAggregation.this.absoluteFieldPath, facetsCollector, nestedDocsProvider);
            return facetCounts.getTopChildren(limit, LuceneNumericTermsAggregation.this.absoluteFieldPath, new String[0]);
        }

        SortedSet<E> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
            TreeSet collectedTerms = new TreeSet(descending ? LuceneNumericTermsAggregation.this.termComparator.reversed() : LuceneNumericTermsAggregation.this.termComparator);
            for (LeafReaderContext leaf : reader.leaves()) {
                LeafReader atomicReader = leaf.reader();
                SortedNumericDocValues docValues = atomicReader.getSortedNumericDocValues(LuceneNumericTermsAggregation.this.absoluteFieldPath);
                if (docValues == null) continue;
                while (docValues.nextDoc() != Integer.MAX_VALUE) {
                    for (int i = 0; i < docValues.docValueCount(); ++i) {
                        Object term = LuceneNumericTermsAggregation.this.numericDomain.sortedDocValueToTerm(docValues.nextValue());
                        collectedTerms.add(term);
                        if (collectedTerms.size() <= limit) continue;
                        collectedTerms.remove(collectedTerms.last());
                    }
                }
            }
            return collectedTerms;
        }

        Comparator<E> getAscendingTermComparator() {
            return LuceneNumericTermsAggregation.this.termComparator;
        }

        E labelToTerm(String termAsString) {
            return LuceneNumericTermsAggregation.this.numericDomain.sortedDocValueToTerm(Long.parseLong(termAsString));
        }

        V termToFieldValue(E term) {
            return LuceneNumericTermsAggregation.this.decoder.apply(term);
        }
    }

    private static class TypeSelector<F, E extends Number>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractTypeSelector<F, E> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        private TypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.codec = codec;
        }

        @Override
        public <K> Builder<F, ?, K, ?> type(Class<K> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new Builder(this.codec, this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, (EventContextProvider)this.field), Function.identity());
            }
            return new Builder(this.codec, this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, (EventContextProvider)this.field), this.codec::decode);
        }
    }

    public static class Factory<F, E extends Number>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<TermsAggregationBuilder.TypeSelector, F, AbstractLuceneNumericFieldCodec<F, E>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public TermsAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TypeSelector((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }
}

