/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.facet.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.search.Query;

public class MultiValueRangeFacetCounts
extends Facets {
    protected final Range[] ranges;
    protected final int[] counts;
    protected final Query fastMatchQuery;
    protected final String field;
    protected int totCount;

    protected MultiValueRangeFacetCounts(String field, Range[] ranges, Query fastMatchQuery) {
        this.field = field;
        this.ranges = ranges;
        this.fastMatchQuery = fastMatchQuery;
        this.counts = new int[ranges.length];
    }

    public FacetResult getAllChildren(String dim, String ... path) {
        throw new UnsupportedOperationException("Getting all children is not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.ranges[i].label, (Number)this.counts[i]);
        }
        return new FacetResult(dim, path, (Number)this.totCount, labelValues, labelValues.length);
    }

    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MultiValueRangeFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            b.append("  ");
            b.append(this.ranges[i].label);
            b.append(" -> count=");
            b.append(this.counts[i]);
            b.append('\n');
        }
        return b.toString();
    }
}

