/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldHighlightProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneTextTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStringFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextMatchPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextPhrasePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextPrefixPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRangePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRegexpPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextTermsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextWildcardPredicate;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneStandardFieldSort;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultStringConverters;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneStringIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep, String>
implements StringIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private Analyzer analyzer;
    private String searchAnalyzerName;
    private Analyzer searchAnalyzer;
    private String normalizerName;
    private Analyzer normalizer;
    private Norms norms = Norms.DEFAULT;
    private TermVector termVector = TermVector.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;
    private Set<Highlightable> highlightable;

    LuceneStringIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class, DefaultStringConverters.STRING);
    }

    public LuceneStringIndexFieldTypeOptionsStep analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        this.analyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep searchAnalyzer(String searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        this.searchAnalyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(searchAnalyzerName);
        if (this.searchAnalyzer == null) {
            throw log.unknownAnalyzer(searchAnalyzerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        this.normalizer = this.getAnalysisDefinitionRegistry().getNormalizerDefinition(normalizerName);
        if (this.normalizer == null) {
            throw log.unknownNormalizer(normalizerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep highlightable(Collection<Highlightable> highlightable) {
        Contracts.assertNotNull(highlightable, (String)"highlightable");
        this.highlightable = highlightable.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(highlightable);
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexValueFieldType<String> toIndexFieldType() {
        DocValues docValues;
        boolean resolvedSortable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = this.resolveProjectable();
        boolean resolvedSearchable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        boolean resolvedNorms = this.resolveNorms();
        ResolvedTermVector resolvedTermVector = this.resolveTermVector();
        this.builder.hasTermVectorsConfigured(resolvedTermVector.hasAnyEnabled());
        DocValues docValues2 = docValues = resolvedSortable || resolvedAggregable ? DocValues.ENABLED : DocValues.DISABLED;
        if (this.analyzer != null) {
            this.builder.analyzerName(this.analyzerName);
            this.builder.searchAnalyzerName(this.searchAnalyzerName);
            this.builder.indexingAnalyzerOrNormalizer(this.analyzer);
            this.builder.searchAnalyzerOrNormalizer(this.searchAnalyzer != null ? this.searchAnalyzer : this.analyzer);
            Set<SearchHighlighterType> allowedHighlighterTypes = this.resolveAllowedHighlighterTypes();
            this.builder.allowedHighlighterTypes(allowedHighlighterTypes);
            if (!allowedHighlighterTypes.isEmpty()) {
                this.builder.queryElementFactory(ProjectionTypeKeys.HIGHLIGHT, new LuceneFieldHighlightProjection.Factory());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.buildContext.getEventContext());
            }
            if (this.normalizer != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.buildContext.getEventContext());
            }
            if (this.indexNullAsValue != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, (String)this.indexNullAsValue, this.buildContext.getEventContext());
            }
            if (resolvedAggregable) {
                throw log.cannotUseAnalyzerOnAggregableField(this.analyzerName, this.buildContext.getEventContext());
            }
        } else {
            if (this.normalizer != null) {
                this.builder.normalizerName(this.normalizerName);
                this.builder.searchAnalyzerName(this.searchAnalyzerName);
                this.builder.indexingAnalyzerOrNormalizer(this.normalizer);
                this.builder.searchAnalyzerOrNormalizer(this.searchAnalyzer != null ? this.searchAnalyzer : this.normalizer);
            } else {
                this.builder.indexingAnalyzerOrNormalizer(AnalyzerConstants.KEYWORD_ANALYZER);
                this.builder.searchAnalyzerOrNormalizer(AnalyzerConstants.KEYWORD_ANALYZER);
            }
            if (this.searchAnalyzer != null) {
                throw log.searchAnalyzerWithoutAnalyzer(this.searchAnalyzerName, this.buildContext.getEventContext());
            }
        }
        LuceneStringFieldCodec codec = new LuceneStringFieldCodec(LuceneStringIndexFieldTypeOptionsStep.getFieldType(resolvedProjectable, resolvedSearchable, this.analyzer != null, resolvedNorms, resolvedTermVector), docValues, (String)this.indexNullAsValue, this.builder.indexingAnalyzerOrNormalizer());
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new LuceneTextMatchPredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new LuceneTextRangePredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.TERMS, new LuceneTextTermsPredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, resolvedNorms || DocValues.ENABLED.equals((Object)docValues) ? new LuceneExistsPredicate.DocValuesOrNormsBasedFactory() : new LuceneExistsPredicate.DefaultFactory());
            this.builder.queryElementFactory(PredicateTypeKeys.PHRASE, new LuceneTextPhrasePredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.PREFIX, new LuceneTextPrefixPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.WILDCARD, new LuceneTextWildcardPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.REGEXP, new LuceneTextRegexpPredicate.Factory());
            this.builder.queryElementFactory(LucenePredicateTypeKeys.SIMPLE_QUERY_STRING, new LuceneCommonQueryStringPredicateBuilderFieldState.Factory(codec));
            this.builder.queryElementFactory(LucenePredicateTypeKeys.QUERY_STRING, new LuceneCommonQueryStringPredicateBuilderFieldState.Factory(codec));
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new LuceneStandardFieldSort.TextFieldFactory<String>(codec));
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<String, String>(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new LuceneTextTermsAggregation.Factory());
        }
        return this.builder.build();
    }

    @Override
    protected LuceneStringIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.buildContext.getAnalysisDefinitionRegistry();
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + String.valueOf(this.norms));
    }

    private ResolvedTermVector resolveTermVector() {
        TermVector localTermVector = this.termVector;
        if (this.highlightable != null && (this.highlightable.contains(Highlightable.ANY) || this.highlightable.contains(Highlightable.FAST_VECTOR))) {
            if (TermVector.DEFAULT.equals((Object)this.termVector)) {
                localTermVector = TermVector.WITH_POSITIONS_OFFSETS;
            } else if (TermVector.WITH_POSITIONS_OFFSETS.equals((Object)this.termVector) || TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS.equals((Object)this.termVector)) {
                localTermVector = this.termVector;
            } else {
                throw log.termVectorDontAllowFastVectorHighlighter(this.termVector);
            }
        }
        switch (localTermVector) {
            case NO: 
            case DEFAULT: {
                return new ResolvedTermVector(false, false, false, false);
            }
            case YES: {
                return new ResolvedTermVector(true, false, false, false);
            }
            case WITH_POSITIONS: {
                return new ResolvedTermVector(true, true, false, false);
            }
            case WITH_OFFSETS: {
                return new ResolvedTermVector(true, false, true, false);
            }
            case WITH_POSITIONS_OFFSETS: {
                return new ResolvedTermVector(true, true, true, false);
            }
            case WITH_POSITIONS_PAYLOADS: {
                return new ResolvedTermVector(true, true, false, true);
            }
            case WITH_POSITIONS_OFFSETS_PAYLOADS: {
                return new ResolvedTermVector(true, true, true, true);
            }
        }
        throw new AssertionFailure("Unexpected value for TermVector: " + String.valueOf(localTermVector));
    }

    private static FieldType getFieldType(boolean projectable, boolean searchable, boolean analyzed, boolean norms, ResolvedTermVector termVector) {
        FieldType fieldType = new FieldType();
        if (!searchable) {
            if (!projectable) {
                return null;
            }
            fieldType.setIndexOptions(IndexOptions.NONE);
            fieldType.setStored(true);
            fieldType.freeze();
            return fieldType;
        }
        if (analyzed) {
            fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            termVector.applyTo(fieldType);
            fieldType.setTokenized(true);
        } else {
            fieldType.setIndexOptions(IndexOptions.DOCS);
            fieldType.setTokenized(true);
        }
        fieldType.setStored(projectable);
        fieldType.setOmitNorms(!norms);
        fieldType.freeze();
        return fieldType;
    }

    private boolean resolveProjectable() {
        if (this.highlightable != null && !this.highlightable.contains(Highlightable.NO)) {
            return true;
        }
        return LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
    }

    private Set<SearchHighlighterType> resolveAllowedHighlighterTypes() {
        if (this.highlightable == null) {
            this.highlightable = EnumSet.of(Highlightable.DEFAULT);
        }
        if (this.highlightable.isEmpty()) {
            throw log.noHighlightableProvided();
        }
        if (this.highlightable.contains(Highlightable.DEFAULT) && Projectable.YES.equals((Object)this.projectable)) {
            this.highlightable = TermVector.WITH_POSITIONS_OFFSETS.equals((Object)this.termVector) || TermVector.WITH_POSITIONS_OFFSETS_PAYLOADS.equals((Object)this.termVector) ? EnumSet.of(Highlightable.ANY) : EnumSet.of(Highlightable.UNIFIED, Highlightable.PLAIN);
        }
        if (this.highlightable.contains(Highlightable.NO)) {
            if (this.highlightable.size() == 1) {
                return Collections.emptySet();
            }
            throw log.unsupportedMixOfHighlightableValues(this.highlightable);
        }
        if (this.highlightable.contains(Highlightable.ANY)) {
            return EnumSet.of(SearchHighlighterType.PLAIN, SearchHighlighterType.UNIFIED, SearchHighlighterType.FAST_VECTOR);
        }
        HashSet<SearchHighlighterType> highlighters = new HashSet<SearchHighlighterType>();
        if (this.highlightable.contains(Highlightable.PLAIN)) {
            highlighters.add(SearchHighlighterType.PLAIN);
        }
        if (this.highlightable.contains(Highlightable.UNIFIED)) {
            highlighters.add(SearchHighlighterType.UNIFIED);
        }
        if (this.highlightable.contains(Highlightable.FAST_VECTOR)) {
            highlighters.add(SearchHighlighterType.FAST_VECTOR);
        }
        return highlighters.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(highlighters);
    }

    private static final class ResolvedTermVector {
        private final boolean store;
        private final boolean positions;
        private final boolean offsets;
        private final boolean payloads;

        private ResolvedTermVector(boolean store, boolean positions, boolean offsets, boolean payloads) {
            this.store = store;
            this.positions = positions;
            this.offsets = offsets;
            this.payloads = payloads;
        }

        private void applyTo(FieldType fieldType) {
            fieldType.setStoreTermVectors(this.store);
            fieldType.setStoreTermVectorPositions(this.positions);
            fieldType.setStoreTermVectorOffsets(this.offsets);
            fieldType.setStoreTermVectorPayloads(this.payloads);
        }

        private boolean hasAnyEnabled() {
            return this.store || this.positions || this.offsets || this.payloads;
        }
    }
}

