/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisDescriptor;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;
import org.hibernate.search.engine.backend.analysis.AnalyzerDescriptor;
import org.hibernate.search.engine.backend.analysis.NormalizerDescriptor;
import org.hibernate.search.engine.backend.analysis.spi.AnalysisDescriptorRegistry;

public final class LuceneAnalysisDefinitionRegistry
implements AnalysisDescriptorRegistry {
    private final Similarity similarity;
    private final Map<String, LuceneAnalysisDescriptor> analyzerDescriptors;
    private final Map<String, LuceneAnalysisDescriptor> normalizerDefinitions;

    public LuceneAnalysisDefinitionRegistry(LuceneAnalysisDefinitionContributor contributor) {
        this.similarity = contributor.getSimilarity().orElseGet(LuceneAnalysisDefinitionRegistry::createDefaultSimilarity);
        this.analyzerDescriptors = new TreeMap<String, LuceneAnalysisDescriptor>();
        this.normalizerDefinitions = new TreeMap<String, LuceneAnalysisDescriptor>();
        contributor.contribute(new LuceneAnalysisDefinitionCollector(){

            @Override
            public void collectAnalyzer(String name, Analyzer analyzer) {
                LuceneAnalysisDefinitionRegistry.this.analyzerDescriptors.put(name, new LuceneAnalysisDescriptor(name, analyzer));
            }

            @Override
            public void collectNormalizer(String name, Analyzer normalizer) {
                LuceneAnalysisDefinitionRegistry.this.normalizerDefinitions.put(name, new LuceneAnalysisDescriptor(name, normalizer));
            }
        });
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzerDefinition(String name) {
        return this.analyzerDescriptor(name).map(LuceneAnalysisDescriptor.class::cast).map(LuceneAnalysisDescriptor::analyzer).orElse(null);
    }

    public Optional<? extends AnalyzerDescriptor> analyzerDescriptor(String name) {
        return Optional.ofNullable(this.analyzerDescriptors.get(name));
    }

    public Analyzer getNormalizerDefinition(String name) {
        return this.normalizerDescriptor(name).map(LuceneAnalysisDescriptor.class::cast).map(LuceneAnalysisDescriptor::analyzer).orElse(null);
    }

    private static Similarity createDefaultSimilarity() {
        return new BM25Similarity();
    }

    public Collection<? extends AnalyzerDescriptor> analyzerDescriptors() {
        return Collections.unmodifiableCollection(this.analyzerDescriptors.values());
    }

    public Optional<? extends NormalizerDescriptor> normalizerDescriptor(String name) {
        return Optional.ofNullable(this.normalizerDefinitions.get(name));
    }

    public Collection<? extends NormalizerDescriptor> normalizerDescriptors() {
        return Collections.unmodifiableCollection(this.normalizerDefinitions.values());
    }
}

