/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneLeafSingleFieldPredicate
extends AbstractLuceneSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Query query;

    protected AbstractLuceneLeafSingleFieldPredicate(AbstractBuilder<?> builder) {
        super(builder);
        this.query = builder.buildQuery();
    }

    @Override
    protected final Query doToQuery(PredicateRequestContext context) {
        return this.query;
    }

    public static abstract class AbstractBuilder<F>
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder {
        protected final LuceneSearchIndexValueFieldContext<F> field;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.field = field;
        }

        protected abstract Query buildQuery();

        protected <E> E convertAndEncode(LuceneStandardFieldCodec<F, E> codec, Object value, ValueConvert convert) {
            DslConverter toFieldValueConverter = this.field.type().dslConverter(convert);
            try {
                Object converted = toFieldValueConverter.unknownTypeToDocumentValue(value, this.scope.toDocumentValueConvertContext());
                return codec.encode(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, this.field.eventContext());
            }
        }

        protected <E> Range<E> convertAndEncode(LuceneStandardFieldCodec<F, E> codec, Range<?> range, ValueConvert convertLowerBound, ValueConvert convertUpperBound) {
            return Range.between(this.convertAndEncode(codec, range.lowerBoundValue(), convertLowerBound), (RangeBoundInclusion)range.lowerBoundInclusion(), this.convertAndEncode(codec, range.upperBoundValue(), convertUpperBound), (RangeBoundInclusion)range.upperBoundInclusion());
        }

        private <E> E convertAndEncode(LuceneStandardFieldCodec<F, E> codec, Optional<?> valueOptional, ValueConvert convert) {
            if (!valueOptional.isPresent()) {
                return null;
            }
            return this.convertAndEncode(codec, valueOptional.get(), convert);
        }
    }
}

