/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.backend.lucene.lowlevel.directory.LockingStrategyName;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.reporting.EventContext;

public class DirectoryCreationContextImpl
implements DirectoryCreationContext {
    private static final OptionalConfigurationProperty<LockingStrategyName> LOCKING_STRATEGY = ConfigurationProperty.forKey((String)"locking.strategy").as(LockingStrategyName.class, LockingStrategyName::of).build();
    private final EventContext eventContext;
    private final String indexName;
    private final Optional<String> shardId;
    private final BeanResolver beanResolver;
    private final ConfigurationPropertySource configurationPropertySource;

    public DirectoryCreationContextImpl(EventContext eventContext, String indexName, Optional<String> shardId, BeanResolver beanResolver, ConfigurationPropertySource configurationPropertySource) {
        this.eventContext = eventContext;
        this.indexName = indexName;
        this.shardId = shardId;
        this.beanResolver = beanResolver;
        this.configurationPropertySource = configurationPropertySource;
    }

    @Override
    public EventContext eventContext() {
        return this.eventContext;
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    @Override
    public Optional<String> shardId() {
        return this.shardId;
    }

    @Override
    public BeanResolver beanResolver() {
        return this.beanResolver;
    }

    @Override
    public ConfigurationPropertySource configurationPropertySource() {
        return this.configurationPropertySource;
    }

    @Override
    public Optional<Supplier<LockFactory>> createConfiguredLockFactorySupplier() {
        return ((Optional)LOCKING_STRATEGY.get(this.configurationPropertySource)).map(DirectoryCreationContextImpl::createLockFactorySupplier);
    }

    private static Supplier<LockFactory> createLockFactorySupplier(LockingStrategyName name) {
        switch (name) {
            case SIMPLE_FILESYSTEM: {
                return () -> SimpleFSLockFactory.INSTANCE;
            }
            case NATIVE_FILESYSTEM: {
                return () -> NativeFSLockFactory.INSTANCE;
            }
            case SINGLE_INSTANCE: {
                return () -> new SingleInstanceLockFactory();
            }
            case NONE: {
                return () -> NoLockFactory.INSTANCE;
            }
        }
        throw new AssertionFailure("Unexpected name: " + name);
    }
}

