/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneKnnPredicate;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.LuceneVectorFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneVectorFieldTypeOptionsStep<S extends AbstractLuceneVectorFieldTypeOptionsStep<?, F>, F>
extends AbstractLuceneIndexFieldTypeOptionsStep<S, F>
implements LuceneVectorFieldTypeOptionsStep<S, F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int MAX_BEAM_WIDTH = 3200;
    private static final int MAX_MAX_CONNECTIONS = 512;
    protected VectorSimilarity vectorSimilarity = VectorSimilarity.DEFAULT;
    protected final int dimension;
    protected int beamWidth = 512;
    protected int maxConnections = 16;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;
    private F indexNullAsValue = null;

    AbstractLuceneVectorFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, Class<F> valueType, int dimension) {
        super(buildContext, valueType);
        if (dimension < 1 || dimension > 1024) {
            throw log.vectorPropertyUnsupportedValue("dimension", dimension, 1024);
        }
        this.dimension = dimension;
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S vectorSimilarity(VectorSimilarity vectorSimilarity) {
        this.vectorSimilarity = vectorSimilarity;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S beamWidth(int beamWidth) {
        if (beamWidth < 1 || beamWidth > 3200) {
            throw log.vectorPropertyUnsupportedValue("beamWidth", beamWidth, 3200);
        }
        this.beamWidth = beamWidth;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S maxConnections(int maxConnections) {
        if (maxConnections < 1 || maxConnections > 512) {
            throw log.vectorPropertyUnsupportedValue("maxConnections", maxConnections, 512);
        }
        this.maxConnections = maxConnections;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S indexNullAs(F indexNullAsValue) {
        this.indexNullAsValue = indexNullAsValue;
        return (S)((AbstractLuceneVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public LuceneIndexValueFieldType<F> toIndexFieldType() {
        VectorSimilarityFunction resolvedVectorSimilarity = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.vectorSimilarity);
        boolean resolvedProjectable = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = AbstractLuceneVectorFieldTypeOptionsStep.resolveDefault(this.searchable);
        Indexing indexing = resolvedSearchable ? Indexing.ENABLED : Indexing.DISABLED;
        Storage storage = resolvedProjectable ? Storage.ENABLED : Storage.DISABLED;
        AbstractLuceneVectorFieldCodec<F> codec = this.createCodec(resolvedVectorSimilarity, this.dimension, storage, indexing, this.indexNullAsValue, new HibernateSearchKnnVectorsFormat(this.maxConnections, this.beamWidth));
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new LuceneExistsPredicate.DocValuesOrNormsBasedFactory());
            this.builder.queryElementFactory(PredicateTypeKeys.KNN, new LuceneKnnPredicate.DefaultFactory());
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<F>(codec));
        }
        this.builder.multivaluable(false);
        return this.builder.build();
    }

    protected abstract AbstractLuceneVectorFieldCodec<F> createCodec(VectorSimilarityFunction var1, int var2, Storage var3, Indexing var4, F var5, HibernateSearchKnnVectorsFormat var6);

    private static VectorSimilarityFunction resolveDefault(VectorSimilarity vectorSimilarity) {
        switch (vectorSimilarity) {
            case DEFAULT: 
            case L2: {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
            case INNER_PRODUCT: {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
            case COSINE: {
                return VectorSimilarityFunction.COSINE;
            }
        }
        throw new AssertionFailure("Unexpected value for Similarity: " + vectorSimilarity);
    }

    protected static boolean resolveDefault(Projectable projectable) {
        switch (projectable) {
            case DEFAULT: 
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
        }
        throw new AssertionFailure("Unexpected value for Projectable: " + projectable);
    }

    protected static boolean resolveDefault(Searchable searchable) {
        switch (searchable) {
            case DEFAULT: 
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new AssertionFailure("Unexpected value for Searchable: " + searchable);
    }
}

