/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.highlighter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldHighlightProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterFragmenter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

class LucenePlainSearchHighlighter
extends LuceneAbstractSearchHighlighter {
    private static final Comparator<TextFragment> SCORE_COMPARATOR = Comparator.comparingDouble(TextFragment::getScore).reversed();
    private static final NullFragmenter NULL_FRAGMENTER = new NullFragmenter();
    private static final LucenePlainSearchHighlighter DEFAULTS = new LucenePlainSearchHighlighter(BoundaryScannerType.SENTENCE);

    private LucenePlainSearchHighlighter(BoundaryScannerType scannerType) {
        super(scannerType);
    }

    protected LucenePlainSearchHighlighter(LuceneAbstractSearchHighlighter.Builder builder) {
        super(builder);
    }

    private LucenePlainSearchHighlighter(Set<String> indexNames, Character[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        super(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
    }

    @Override
    protected LuceneAbstractSearchHighlighter createHighlighterSameType(Set<String> indexNames, Character[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        return new LucenePlainSearchHighlighter(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
    }

    @Override
    public LuceneAbstractSearchHighlighter withFallbackDefaults() {
        return this.withFallback(DEFAULTS);
    }

    @Override
    public <A> Values<A> createValues(String parentDocumentPath, String nestedDocumentPath, String absoluteFieldPath, Analyzer analyzer, ProjectionExtractContext context, ProjectionAccumulator<String, ?, A, List<String>> accumulator) {
        return new PlainHighlighterValues<A>(parentDocumentPath, nestedDocumentPath, absoluteFieldPath, analyzer, context, accumulator);
    }

    @Override
    public SearchHighlighterType type() {
        return SearchHighlighterType.PLAIN;
    }

    @Override
    public void request(ProjectionRequestContext context, String absoluteFieldPath) {
        context.requireStoredField(absoluteFieldPath, context.absoluteCurrentNestedFieldPath());
    }

    private final class PlainHighlighterValues<A>
    extends LuceneFieldHighlightProjection.HighlighterValues<A> {
        private final StoredFieldsValuesDelegate storedFieldsValuesDelegate;
        private final Highlighter highlighter;
        private final Analyzer analyzer;
        private final String field;

        PlainHighlighterValues(String parentDocumentPath, String nestedDocumentPath, String field, Analyzer analyzer, ProjectionExtractContext context, ProjectionAccumulator<String, ?, A, List<String>> accumulator) {
            super(parentDocumentPath, nestedDocumentPath, context.collectorExecutionContext(), accumulator);
            this.storedFieldsValuesDelegate = context.collectorExecutionContext().storedFieldsValuesDelegate();
            this.field = field;
            this.analyzer = analyzer;
            QueryScorer queryScorer = new QueryScorer(context.collectorExecutionContext().originalQuery(), field);
            queryScorer.setExpandMultiTermQuery(true);
            Object fragmenter = LucenePlainSearchHighlighter.this.numberOfFragments == 0 ? NULL_FRAGMENTER : (HighlighterFragmenter.SPAN.equals((Object)LucenePlainSearchHighlighter.this.fragmenterType) ? new SimpleSpanFragmenter(queryScorer, LucenePlainSearchHighlighter.this.fragmentSize.intValue()) : new SimpleFragmenter(LucenePlainSearchHighlighter.this.fragmentSize.intValue()));
            this.highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter((String)LucenePlainSearchHighlighter.this.preTags.get(0), (String)LucenePlainSearchHighlighter.this.postTags.get(0)), LucenePlainSearchHighlighter.this.encoder, (Scorer)queryScorer);
            this.highlighter.setTextFragmenter((Fragmenter)fragmenter);
            this.highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
        }

        @Override
        public List<String> highlight(int doc) throws IOException {
            try {
                String text;
                ArrayList<TextFragment> result = new ArrayList<TextFragment>();
                for (Object indexableField : this.storedFieldsValuesDelegate.get(doc).getFields()) {
                    if (!indexableField.name().equals(this.field)) continue;
                    text = indexableField.stringValue();
                    TextFragment[] bestFragments = this.highlighter.getBestTextFragments(this.analyzer.tokenStream(this.field, text), text, false, LucenePlainSearchHighlighter.this.numberOfFragments.intValue());
                    for (int i = 0; i < bestFragments.length; ++i) {
                        if (bestFragments[i] == null || !(bestFragments[i].getScore() > 0.0f)) continue;
                        result.add(bestFragments[i]);
                    }
                }
                if (!result.isEmpty()) {
                    if (Boolean.TRUE.equals(LucenePlainSearchHighlighter.this.orderByScore)) {
                        result.sort(SCORE_COMPARATOR);
                    }
                    ArrayList<String> converted = new ArrayList<String>(result.size());
                    for (TextFragment textFragment : result) {
                        converted.add(textFragment.toString());
                    }
                    return converted;
                }
                if (LucenePlainSearchHighlighter.this.noMatchSize > 0) {
                    for (Object indexableField : this.storedFieldsValuesDelegate.get(doc).getFields()) {
                        if (!indexableField.name().equals(this.field) || (text = indexableField.stringValue()).length() <= 0) continue;
                        return Collections.singletonList(text.substring(0, Math.min(LucenePlainSearchHighlighter.this.noMatchSize, text.length())));
                    }
                }
                return Collections.emptyList();
            }
            catch (InvalidTokenOffsetsException e) {
                throw new IOException(e);
            }
        }
    }
}

