/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.query.impl;

import org.apache.lucene.search.DocIdSetIterator;

public final class ExplicitDocIdSetIterator
extends DocIdSetIterator {
    private final int[] sortedTopLevelDocIds;
    private final int leafDocBase;
    private final int firstIndex;
    private final int leafMaxDocId;
    private int index;
    private int leafDocId = -1;

    public static DocIdSetIterator of(int[] sortedTopLevelDocIds, int leafDocBase, int leafMaxLeafId) {
        int firstIndex = ExplicitDocIdSetIterator.findFirstGreaterThanOrEqualTo(sortedTopLevelDocIds, leafDocBase);
        if (firstIndex < 0) {
            return null;
        }
        return new ExplicitDocIdSetIterator(sortedTopLevelDocIds, leafDocBase, firstIndex, leafMaxLeafId);
    }

    private static int findFirstGreaterThanOrEqualTo(int[] values, int min) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] < min) continue;
            return i;
        }
        return -1;
    }

    ExplicitDocIdSetIterator(int[] sortedTopLevelDocIds, int leafDocBase, int firstIndex, int leafMaxDocId) {
        this.sortedTopLevelDocIds = sortedTopLevelDocIds;
        this.leafDocBase = leafDocBase;
        this.firstIndex = firstIndex;
        this.leafMaxDocId = leafMaxDocId;
        this.index = firstIndex;
    }

    public int docID() {
        return this.leafDocId;
    }

    public int nextDoc() {
        if (this.index < this.sortedTopLevelDocIds.length) {
            this.leafDocId = this.sortedTopLevelDocIds[this.index] - this.leafDocBase;
            ++this.index;
            if (this.leafDocId < this.leafMaxDocId) {
                return this.leafDocId;
            }
        }
        this.leafDocId = Integer.MAX_VALUE;
        return this.leafDocId;
    }

    public int advance(int target) {
        int doc;
        while ((doc = this.nextDoc()) < target) {
        }
        return doc;
    }

    public long cost() {
        return (long)this.sortedTopLevelDocIds.length - (long)this.firstIndex;
    }
}

