/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;

public class TopDocsDataCollector<T>
extends SimpleCollector {
    private final Values<? extends T> values;
    private final StoredFieldsValuesDelegate storedFieldsValuesDelegate;
    private final IntObjectMap<T> collected = new IntObjectHashMap();
    private int currentLeafDocBase;

    public TopDocsDataCollector(TopDocsDataCollectorExecutionContext context, Values<? extends T> values) {
        this.values = values;
        this.storedFieldsValuesDelegate = context.storedFieldsValuesDelegate();
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.storedFieldsValuesDelegate != null) {
            this.storedFieldsValuesDelegate.context(context);
        }
        this.values.context(context);
        this.currentLeafDocBase = context.docBase;
    }

    public void collect(int doc) throws IOException {
        if (this.storedFieldsValuesDelegate != null) {
            this.storedFieldsValuesDelegate.collect(doc);
        }
        this.collected.put(this.currentLeafDocBase + doc, this.values.get(doc));
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public T get(int doc) {
        return (T)this.collected.get(doc);
    }

    public static interface Factory<T>
    extends CollectorKey<TopDocsDataCollector<T>> {
        public TopDocsDataCollector<T> create(TopDocsDataCollectorExecutionContext var1) throws IOException;
    }
}

