/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.codec.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene95.Lucene95HnswVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class HibernateSearchKnnVectorsFormat
extends KnnVectorsFormat {
    public static final int DEFAULT_MAX_DIMENSIONS = 1024;
    private static final KnnVectorsFormat DEFAULT_KNN_VECTORS_FORMAT = new HibernateSearchKnnVectorsFormat();
    private final KnnVectorsFormat delegate;
    private final int maxConnection;
    private final int beamWidth;

    public static KnnVectorsFormat defaultFormat() {
        return DEFAULT_KNN_VECTORS_FORMAT;
    }

    public HibernateSearchKnnVectorsFormat() {
        this(16, 100);
    }

    public HibernateSearchKnnVectorsFormat(int maxConnection, int beamWidth) {
        this((KnnVectorsFormat)new Lucene95HnswVectorsFormat(maxConnection, beamWidth), maxConnection, beamWidth);
    }

    public HibernateSearchKnnVectorsFormat(KnnVectorsFormat delegate, int maxConnection, int beamWidth) {
        super(delegate.getName());
        this.delegate = delegate;
        this.maxConnection = maxConnection;
        this.beamWidth = beamWidth;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.delegate.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.delegate.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public KnnVectorsFormat delegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HibernateSearchKnnVectorsFormat that = (HibernateSearchKnnVectorsFormat)((Object)o);
        return this.maxConnection == that.maxConnection && this.beamWidth == that.beamWidth;
    }

    public int hashCode() {
        return Objects.hash(this.maxConnection, this.beamWidth);
    }

    public String toString() {
        return "HibernateSearchKnnVectorsFormat{maxConnection=" + this.maxConnection + ", beamWidth=" + this.beamWidth + "}";
    }
}

