/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.TermsPredicateBuilder;

public class LuceneNumericTermsPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneNumericTermsPredicate(Builder<?, ?> builder) {
        super(builder);
    }

    private static class Builder<F, E extends Number>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements TermsPredicateBuilder {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private E term;
        private List<E> terms;
        private boolean allMatch;

        private Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.constantScore();
            this.codec = codec;
        }

        public void matchingAny(Collection<?> terms, ValueConvert convert) {
            this.allMatch = false;
            this.fillTerms(terms, convert);
        }

        public void matchingAll(Collection<?> terms, ValueConvert convert) {
            this.allMatch = true;
            this.fillTerms(terms, convert);
        }

        public SearchPredicate build() {
            return new LuceneNumericTermsPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            if (this.term != null) {
                return this.codec.getDomain().createExactQuery(this.absoluteFieldPath, this.term);
            }
            if (!this.allMatch) {
                return this.codec.getDomain().createSetQuery(this.absoluteFieldPath, this.terms);
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Number termItem : this.terms) {
                Query query = this.codec.getDomain().createExactQuery(this.absoluteFieldPath, termItem);
                builder.add(query, BooleanClause.Occur.MUST);
            }
            return builder.build();
        }

        private void fillTerms(Collection<?> terms, ValueConvert convert) {
            if (terms.size() == 1) {
                this.term = (Number)this.convertAndEncode(this.codec, terms.iterator().next(), convert);
                this.terms = null;
                return;
            }
            this.term = null;
            this.terms = new ArrayList(terms.size());
            for (Object termItem : terms) {
                this.terms.add((Number)this.convertAndEncode(this.codec, termItem, convert));
            }
        }
    }

    public static class Factory<F, E extends Number>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<TermsPredicateBuilder, F, AbstractLuceneNumericFieldCodec<F, E>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public Builder<F, E> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }
}

