/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneLongDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneOffsetTimeFieldCodec
extends AbstractLuceneNumericFieldCodec<OffsetTime, Long> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneLocalTimeFieldCodec.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneOffsetTimeFieldCodec(Indexing indexing, DocValues docValues, Storage storage, OffsetTime indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, OffsetTime value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public OffsetTime decode(IndexableField field) {
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return OffsetTime.parse(value, FORMATTER);
    }

    @Override
    public Long encode(OffsetTime value) {
        if (value == null) {
            return null;
        }
        long nod = value.toLocalTime().toNanoOfDay();
        long offsetNanos = (long)value.getOffset().getTotalSeconds() * 1000000000L;
        return nod - offsetNanos;
    }

    @Override
    public OffsetTime decode(Long encoded) {
        return Instant.EPOCH.plus((long)encoded, ChronoUnit.NANOS).atOffset(ZoneOffset.UTC).toOffsetTime();
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneLongDomain.get();
    }
}

