/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.CollectorSet;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class ExtractionRequirements {
    private final boolean requireScore;
    private final Set<CollectorFactory<?>> requiredCollectorForAllMatchingDocsFactories;
    private final Set<CollectorFactory<?>> requiredCollectorForTopDocsFactories;

    private ExtractionRequirements(Builder builder) {
        this.requireScore = builder.requireScore;
        this.requiredCollectorForAllMatchingDocsFactories = builder.requiredCollectorForAllMatchingDocsFactories;
        this.requiredCollectorForTopDocsFactories = builder.requiredCollectorForTopDocsFactories;
    }

    public LuceneCollectors createCollectors(IndexSearcher indexSearcher, Query originalLuceneQuery, Sort sort, IndexReaderMetadataResolver metadataResolver, int maxDocs, TimeoutManager timeoutManager, int requestedTotalHitCountThreshold) throws IOException {
        Query rewrittenLuceneQuery = indexSearcher.rewrite(originalLuceneQuery);
        int totalHitCountThreshold = rewrittenLuceneQuery instanceof MatchAllDocsQuery ? 0 : requestedTotalHitCountThreshold;
        TopScoreDocCollector topDocsCollector = null;
        Integer scoreSortFieldIndexForRescoring = null;
        boolean requireFieldDocRescoring = false;
        CollectorExecutionContext executionContext = new CollectorExecutionContext(metadataResolver, indexSearcher, maxDocs);
        CollectorSet.Builder collectorsForAllMatchingDocsBuilder = new CollectorSet.Builder(executionContext, timeoutManager);
        if (maxDocs > 0) {
            if (sort == null || this.isDescendingScoreSort(sort)) {
                topDocsCollector = TopScoreDocCollector.create((int)maxDocs, (int)totalHitCountThreshold);
            } else {
                if (this.requireScore) {
                    requireFieldDocRescoring = true;
                    scoreSortFieldIndexForRescoring = this.getScoreSortFieldIndexOrNull(sort);
                }
                topDocsCollector = TopFieldCollector.create((Sort)sort, (int)maxDocs, (int)totalHitCountThreshold);
            }
            collectorsForAllMatchingDocsBuilder.add(LuceneCollectors.TOP_DOCS_KEY, topDocsCollector);
        }
        if (topDocsCollector == null && totalHitCountThreshold > 0) {
            TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
            collectorsForAllMatchingDocsBuilder.add(LuceneCollectors.TOTAL_HIT_COUNT_KEY, totalHitCountCollector);
        }
        collectorsForAllMatchingDocsBuilder.addAll(this.requiredCollectorForAllMatchingDocsFactories);
        CollectorSet collectorsForAllMatchingDocs = collectorsForAllMatchingDocsBuilder.build();
        return new LuceneCollectors(metadataResolver, indexSearcher, rewrittenLuceneQuery, requireFieldDocRescoring, scoreSortFieldIndexForRescoring, collectorsForAllMatchingDocs, this.requiredCollectorForTopDocsFactories, timeoutManager);
    }

    private boolean isDescendingScoreSort(Sort sort) {
        SortField[] fields = sort.getSort();
        return fields.length == 1 && this.isDescendingScoreSort(fields[0]);
    }

    private boolean isDescendingScoreSort(SortField sortField) {
        return SortField.Type.SCORE == sortField.getType() && !sortField.getReverse();
    }

    private Integer getScoreSortFieldIndexOrNull(Sort sort) {
        SortField[] sortFields = sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            return i;
        }
        return null;
    }

    public static class Builder {
        private boolean requireScore;
        private final Set<CollectorFactory<?>> requiredCollectorForAllMatchingDocsFactories = new LinkedHashSet();
        private final Set<CollectorFactory<?>> requiredCollectorForTopDocsFactories = new LinkedHashSet();
        private boolean requireAllStoredFields = false;
        private final Set<String> requiredStoredFields = new HashSet<String>();
        private final Set<String> requiredNestedDocumentPathsForStoredFields = new HashSet<String>();

        public void requireScore() {
            this.requireScore = true;
        }

        public <C extends Collector> void requireCollectorForAllMatchingDocs(CollectorFactory<C> collectorFactory) {
            this.requiredCollectorForAllMatchingDocsFactories.add(collectorFactory);
        }

        public <C extends Collector> void requireCollectorForTopDocs(CollectorFactory<C> collectorFactory) {
            this.requiredCollectorForTopDocsFactories.add(collectorFactory);
        }

        public void requireAllStoredFields() {
            this.requireAllStoredFields = true;
            this.requiredStoredFields.clear();
        }

        public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
            if (!this.requireAllStoredFields) {
                this.requiredStoredFields.add(absoluteFieldPath);
            }
            if (nestedDocumentPath != null) {
                this.requiredNestedDocumentPathsForStoredFields.add(nestedDocumentPath);
            }
        }

        public ExtractionRequirements build() {
            CollectorFactory<StoredFieldsCollector> storedFieldCollectorFactory = this.createStoredFieldCollectorFactoryOrNull();
            if (storedFieldCollectorFactory != null) {
                this.requiredCollectorForTopDocsFactories.add(storedFieldCollectorFactory);
            }
            return new ExtractionRequirements(this);
        }

        private CollectorFactory<StoredFieldsCollector> createStoredFieldCollectorFactoryOrNull() {
            ReusableDocumentStoredFieldVisitor storedFieldVisitor;
            if (this.requireAllStoredFields) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor();
            } else if (!this.requiredStoredFields.isEmpty()) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor(this.requiredStoredFields);
            } else {
                return null;
            }
            return StoredFieldsCollector.factory(storedFieldVisitor, this.requiredNestedDocumentPathsForStoredFields);
        }
    }
}

