/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.join.impl;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;

public class JoinChildrenIdIterator {
    private final BitSet parentDocs;
    private final DocIdSetIterator childDocs;
    private final DocIdSetIterator values;
    private int currentParentDocId = -1;
    private int previousChildDocId = -1;

    public JoinChildrenIdIterator(BitSet parentDocs, DocIdSetIterator childDocs, DocIdSetIterator values) {
        this.parentDocs = parentDocs;
        this.childDocs = childDocs;
        this.values = values;
    }

    public boolean advanceExact(int parentDocId) throws IOException {
        boolean found;
        if (parentDocId == this.currentParentDocId) {
            return this.values.docID() < this.currentParentDocId;
        }
        int prevParentDoc = parentDocId == 0 ? -1 : this.parentDocs.prevSetBit(parentDocId - 1);
        int nextChildDocId = this.advanceValuesToNextChildBeyond(prevParentDoc);
        this.currentParentDocId = parentDocId;
        if (nextChildDocId < this.currentParentDocId) {
            found = true;
            this.previousChildDocId = nextChildDocId - 1;
        } else {
            found = false;
            this.previousChildDocId = Integer.MAX_VALUE;
        }
        return found;
    }

    public boolean advanceValuesToNextChild() throws IOException {
        int nextChildDocId;
        if (this.currentParentDocId <= this.previousChildDocId) {
            return false;
        }
        this.previousChildDocId = nextChildDocId = this.advanceValuesToNextChildBeyond(this.previousChildDocId);
        return nextChildDocId < this.currentParentDocId;
    }

    private int advanceValuesToNextChildBeyond(int previousIdExcluded) throws IOException {
        if (previousIdExcluded == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int currentChildDocId = this.childDocs.docID();
        if (this.childDocs.docID() <= previousIdExcluded) {
            currentChildDocId = this.childDocs.advance(previousIdExcluded + 1);
        }
        int currentValuesDocId = this.values.docID();
        while (currentValuesDocId != currentChildDocId) {
            currentValuesDocId = this.values.advance(currentChildDocId);
            if (currentChildDocId >= currentValuesDocId) continue;
            currentChildDocId = this.childDocs.advance(currentValuesDocId);
        }
        return currentValuesDocId;
    }
}

