/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.util.common.impl.Futures;

class LuceneIndexIndexingPlanExecution<R> {
    private final LuceneSerialWorkOrchestrator orchestrator;
    private final EntityReferenceFactory<R> entityReferenceFactory;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final List<SingleDocumentIndexingWork> works;
    private final CompletableFuture<Long>[] futures;

    LuceneIndexIndexingPlanExecution(LuceneSerialWorkOrchestrator orchestrator, EntityReferenceFactory<R> entityReferenceFactory, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, List<SingleDocumentIndexingWork> works) {
        this.orchestrator = orchestrator;
        this.entityReferenceFactory = entityReferenceFactory;
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
        this.works = works;
        this.futures = new CompletableFuture[works.size()];
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i] = new CompletableFuture();
        }
    }

    CompletableFuture<IndexIndexingPlanExecutionReport<R>> execute() {
        CompletionStage reportFuture = CompletableFuture.allOf(this.futures).handle((result, throwable) -> this.onAllWorksFinished());
        for (int i = 0; i < this.works.size(); ++i) {
            CompletableFuture<Long> future = this.futures[i];
            SingleDocumentIndexingWork work = this.works.get(i);
            this.orchestrator.submit(future, work);
        }
        return reportFuture;
    }

    private IndexIndexingPlanExecutionReport<R> onAllWorksFinished() {
        RuntimeException commitOrRefreshThrowable = null;
        try {
            this.commitOrRefreshAsNecessary();
        }
        catch (RuntimeException e) {
            commitOrRefreshThrowable = e;
        }
        return this.buildReport(commitOrRefreshThrowable);
    }

    private void commitOrRefreshAsNecessary() {
        if (DocumentCommitStrategy.FORCE == this.commitStrategy) {
            this.orchestrator.forceCommitInCurrentThread();
        }
        if (DocumentRefreshStrategy.FORCE == this.refreshStrategy) {
            this.orchestrator.forceRefreshInCurrentThread();
        }
    }

    private IndexIndexingPlanExecutionReport<R> buildReport(Throwable commitOrRefreshThrowable) {
        IndexIndexingPlanExecutionReport.Builder reportBuilder = IndexIndexingPlanExecutionReport.builder();
        for (int i = 0; i < this.futures.length; ++i) {
            CompletableFuture<Long> future = this.futures[i];
            if (future.isCompletedExceptionally()) {
                reportBuilder.throwable(Futures.getThrowableNow(future));
            }
            if (commitOrRefreshThrowable == null && !future.isCompletedExceptionally()) continue;
            SingleDocumentIndexingWork work = this.works.get(i);
            reportBuilder.failingEntityReference(this.entityReferenceFactory, work.getEntityTypeName(), work.getEntityIdentifier());
        }
        if (commitOrRefreshThrowable != null) {
            reportBuilder.throwable(commitOrRefreshThrowable);
        }
        return reportBuilder.build();
    }
}

