/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneNestableAggregation<A>
implements LuceneSearchAggregation<A> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String nestedDocumentPath;
    private final Query nestedFilter;

    AbstractLuceneNestableAggregation(AbstractBuilder<A> builder) {
        this.nestedDocumentPath = ((AbstractBuilder)builder).nestedDocumentPath;
        this.nestedFilter = ((AbstractBuilder)builder).nestedFilter;
    }

    protected NestedDocsProvider createNestedDocsProvider(AggregationExtractContext context) {
        NestedDocsProvider nestedDocsProvider = null;
        if (this.nestedDocumentPath != null) {
            nestedDocsProvider = context.createNestedDocsProvider(this.nestedDocumentPath, this.nestedFilter);
        }
        return nestedDocsProvider;
    }

    public static abstract class AbstractBuilder<A>
    implements SearchAggregationBuilder<A> {
        protected final LuceneSearchContext searchContext;
        protected final LuceneSearchValueFieldContext<?> field;
        private final String nestedDocumentPath;
        private Query nestedFilter;

        public AbstractBuilder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<?> field) {
            this.searchContext = searchContext;
            this.field = field;
            this.nestedDocumentPath = field.nestedDocumentPath();
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedDocumentPath == null) {
                throw log.cannotFilterAggregationOnRootDocumentField(this.field.absolutePath(), this.field.eventContext());
            }
            LuceneSearchPredicate luceneFilter = LuceneSearchPredicate.from(this.searchContext, filter);
            luceneFilter.checkNestableWithin(this.nestedDocumentPath);
            PredicateRequestContext filterContext = new PredicateRequestContext(this.nestedDocumentPath);
            this.nestedFilter = luceneFilter.toQuery(filterContext);
        }

        public abstract LuceneSearchAggregation<A> build();
    }
}

