/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

class LuceneNestedPredicate
extends AbstractLuceneSingleFieldPredicate {
    private final LuceneSearchPredicate nestedPredicate;

    private LuceneNestedPredicate(Builder builder) {
        super(builder);
        this.nestedPredicate = builder.nestedPredicate;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        PredicateRequestContext childContext = new PredicateRequestContext(this.absoluteFieldPath);
        return LuceneNestedPredicate.createNestedQuery(context.getNestedPath(), this.absoluteFieldPath, this.nestedPredicate.toQuery(childContext));
    }

    public static Query createNestedQuery(String parentNestedDocumentPath, String nestedDocumentPath, Query nestedQuery) {
        if (nestedDocumentPath.equals(parentNestedDocumentPath)) {
            return nestedQuery;
        }
        BooleanQuery.Builder childQueryBuilder = new BooleanQuery.Builder();
        childQueryBuilder.add(Queries.childDocumentQuery(), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(Queries.nestedDocumentPathQuery(nestedDocumentPath), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(nestedQuery, BooleanClause.Occur.MUST);
        QueryBitSetProducer parentFilter = new QueryBitSetProducer(Queries.parentsFilterQuery(parentNestedDocumentPath));
        return new ToParentBlockJoinQuery((Query)childQueryBuilder.build(), (BitSetProducer)parentFilter, ScoreMode.Avg);
    }

    static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements NestedPredicateBuilder {
        private LuceneSearchPredicate nestedPredicate;

        Builder(LuceneSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext, absoluteFieldPath, nestedPathHierarchy.subList(0, nestedPathHierarchy.size() - 1));
        }

        public void nested(SearchPredicate nestedPredicate) {
            LuceneSearchPredicate luceneNestedPredicate = LuceneSearchPredicate.from(this.searchContext, nestedPredicate);
            luceneNestedPredicate.checkNestableWithin(this.absoluteFieldPath);
            this.nestedPredicate = luceneNestedPredicate;
        }

        public SearchPredicate build() {
            return new LuceneNestedPredicate(this);
        }
    }
}

