/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationTypeKeys;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregationCollector;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchAggregationBuilderFactory
implements SearchAggregationBuilderFactory<LuceneSearchAggregationCollector> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    private final LuceneSearchIndexesContext indexes;

    public LuceneSearchAggregationBuilderFactory(LuceneSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public <A> void contribute(LuceneSearchAggregationCollector collector, AggregationKey<A> key, SearchAggregation<A> aggregation) {
        if (!(aggregation instanceof LuceneSearchAggregation)) {
            throw log.cannotMixLuceneSearchQueryWithOtherAggregations(aggregation);
        }
        LuceneSearchAggregation casted = (LuceneSearchAggregation)aggregation;
        if (!this.indexes.indexNames().equals(casted.getIndexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.getIndexNames(), this.indexes.indexNames());
        }
        collector.collectAggregation(key, casted);
    }

    public <T> TermsAggregationBuilder<T> createTermsAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        return this.indexes.field(absoluteFieldPath).queryElement(AggregationTypeKeys.TERMS, this.searchContext).type(expectedType, convert);
    }

    public <T> RangeAggregationBuilder<T> createRangeAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        return this.indexes.field(absoluteFieldPath).queryElement(AggregationTypeKeys.RANGE, this.searchContext).type(expectedType, convert);
    }
}

