/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.impl;

import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;

public class LuceneIndexScope
implements IndexScope<LuceneSearchQueryElementCollector> {
    private final LuceneSearchContext searchContext;
    private final LuceneSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final LuceneSearchSortBuilderFactoryImpl searchSortFactory;
    private final LuceneSearchQueryBuilderFactory searchQueryFactory;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;
    private final LuceneSearchAggregationBuilderFactory searchAggregationFactory;

    public LuceneIndexScope(SearchBackendContext backendContext, BackendMappingContext mappingContext, LuceneSearchIndexesContext indexes) {
        this.searchContext = backendContext.createSearchContext(mappingContext, indexes);
        this.searchPredicateFactory = new LuceneSearchPredicateBuilderFactoryImpl(this.searchContext);
        this.searchSortFactory = new LuceneSearchSortBuilderFactoryImpl(this.searchContext);
        this.searchProjectionFactory = new LuceneSearchProjectionBuilderFactory(this.searchContext);
        this.searchAggregationFactory = new LuceneSearchAggregationBuilderFactory(this.searchContext);
        this.searchQueryFactory = new LuceneSearchQueryBuilderFactory(backendContext, this.searchContext, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.searchContext.indexes().indexNames() + "]";
    }

    public LuceneSearchPredicateBuilderFactoryImpl searchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public LuceneSearchSortBuilderFactoryImpl searchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public LuceneSearchQueryBuilderFactory searchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public LuceneSearchProjectionBuilderFactory searchProjectionFactory() {
        return this.searchProjectionFactory;
    }

    public SearchAggregationBuilderFactory<? super LuceneSearchQueryElementCollector> searchAggregationFactory() {
        return this.searchAggregationFactory;
    }
}

