/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisConfigurationContextImpl;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneDefaultAnalysisConfigurer;
import org.hibernate.search.backend.lucene.cfg.LuceneBackendSettings;
import org.hibernate.search.backend.lucene.impl.LuceneBackendImpl;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.MultiTenancyStrategyName;
import org.hibernate.search.backend.lucene.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactoryImpl;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Optional<Version>> LUCENE_VERSION = ConfigurationProperty.forKey((String)"lucene_version").as(Version.class, LuceneBackendFactory::parseLuceneVersion).build();
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy.strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::of).withDefault((Object)LuceneBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends LuceneAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis.configurer").asBeanReference(LuceneAnalysisConfigurer.class).build();

    public BackendImplementor create(EventContext eventContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        BackendThreads backendThreads = null;
        try {
            backendThreads = new BackendThreads(eventContext.render());
            Version luceneVersion = this.getLuceneVersion(eventContext, propertySource);
            MultiTenancyStrategy multiTenancyStrategy = this.getMultiTenancyStrategy(propertySource);
            LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(buildContext, propertySource, luceneVersion);
            return new LuceneBackendImpl(eventContext, backendThreads, new LuceneWorkFactoryImpl(multiTenancyStrategy), analysisDefinitionRegistry, multiTenancyStrategy, buildContext.timingSource(), buildContext.failureHandler());
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(BackendThreads::onStop, (Object)backendThreads);
            throw e;
        }
    }

    private Version getLuceneVersion(EventContext backendContext, ConfigurationPropertySource propertySource) {
        Version luceneVersion;
        Optional luceneVersionOptional = (Optional)LUCENE_VERSION.get(propertySource);
        if (luceneVersionOptional.isPresent()) {
            luceneVersion = (Version)luceneVersionOptional.get();
            if (log.isDebugEnabled()) {
                log.debug("Setting Lucene compatibility to Version " + luceneVersion);
            }
        } else {
            Version latestVersion = LuceneBackendSettings.Defaults.LUCENE_VERSION;
            log.recommendConfiguringLuceneVersion(LUCENE_VERSION.resolveOrRaw(propertySource), latestVersion, backendContext);
            luceneVersion = latestVersion;
        }
        return luceneVersion;
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%1$s'.", new Object[]{multiTenancyStrategyName}));
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, Version luceneVersion) {
        try {
            LuceneAnalysisComponentFactory analysisComponentFactory = new LuceneAnalysisComponentFactory(luceneVersion, buildContext.classResolver(), buildContext.resourceResolver());
            LuceneAnalysisConfigurationContextImpl collector = new LuceneAnalysisConfigurationContextImpl(analysisComponentFactory);
            LuceneDefaultAnalysisConfigurer.INSTANCE.configure(collector);
            BeanResolver beanResolver = buildContext.beanResolver();
            ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ((LuceneAnalysisConfigurer)configurerHolder.get()).configure(collector);
                }
            });
            return new LuceneAnalysisDefinitionRegistry(collector);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), e);
        }
    }

    private static Version parseLuceneVersion(String versionString) {
        try {
            return Version.parseLeniently((String)versionString);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw log.illegalLuceneVersionFormat(versionString, e.getMessage(), e);
        }
    }
}

