/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import java.net.URL;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.ClassLoaderAccess;

public class ClassLoaderAccessTestingImpl
implements ClassLoaderAccess {
    public static final ClassLoaderAccessTestingImpl INSTANCE = new ClassLoaderAccessTestingImpl();

    public <T> Class<T> classForName(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoadingException("Could not load class by name : " + name, (Throwable)e);
        }
    }

    public URL locateResource(String resourceName) {
        return this.getClass().getClassLoader().getResource(resourceName);
    }
}

