/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.oracle.Decoders;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class SDOGeometryValueExtractor<X>
extends BasicExtractor<X> {
    public SDOGeometryValueExtractor(JavaType<X> javaType, JdbcType jdbcType) {
        super(javaType, jdbcType);
    }

    protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
        Object geomObj = rs.getObject(paramIndex);
        return (X)this.getJavaType().wrap((Object)this.convert(geomObj), options);
    }

    protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
        Object geomObj = statement.getObject(index);
        return (X)this.getJavaType().wrap((Object)this.convert(geomObj), options);
    }

    protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
        Object geomObj = statement.getObject(name);
        return (X)this.getJavaType().wrap((Object)this.convert(geomObj), options);
    }

    public Geometry convert(Object struct) {
        if (struct == null) {
            return null;
        }
        SDOGeometry sdogeom = SDOGeometry.load((Struct)((Struct)struct));
        return this.toGeometry(sdogeom);
    }

    private Geometry toGeometry(SDOGeometry sdoGeom) {
        return Decoders.decode((SDOGeometry)sdoGeom);
    }
}

