/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import jakarta.persistence.AccessType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.DiscriminatorMetadata;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.processor.validation.MockSessionFactory;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.Type;

public abstract class MockEntityPersister
implements EntityPersister,
Queryable,
DiscriminatorMetadata {
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] ID_COLUMN = new String[]{"id"};
    private final @UnknownKeyFor @NonNull @Initialized String entityName;
    private final @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MockEntityPersister> subclassPersisters = new ArrayList<MockEntityPersister>();
    final @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Type> propertyTypesByName = new HashMap<String, Type>();

    public MockEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory) {
        this.entityName = entityName;
        this.factory = factory;
        this.defaultAccessType = defaultAccessType;
    }

    void initSubclassPersisters() {
        for (MockEntityPersister other : this.factory.getMockEntityPersisters()) {
            other.addPersister(this);
            this.addPersister(other);
        }
    }

    private void addPersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister entityPersister) {
        if (this.isSubclassPersister(entityPersister)) {
            this.subclassPersisters.add(entityPersister);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Type getSubclassPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
        return this.subclassPersisters.stream().map(sp -> sp.getPropertyType(propertyPath)).filter(Objects::nonNull).findAny().orElse(null);
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isSubclassPersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isSubclassEntityName(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.isSubclassPersister(this.subclassPersisters.stream().filter(persister -> persister.entityName.equals(name)).findFirst().orElseThrow());
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityMetamodel getEntityMetamodel() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public @UnknownKeyFor @NonNull @Initialized String getEntityName() {
        return this.entityName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.entityName;
    }

    public final @UnknownKeyFor @NonNull @Initialized Type getPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
        Type result = this.propertyTypesByName.get(propertyPath);
        if (result != null) {
            return result;
        }
        result = this.createPropertyType(propertyPath);
        if (result == null) {
            result = this.getSubclassPropertyType(propertyPath);
        }
        if (result != null) {
            this.propertyTypesByName.put(propertyPath, result);
        }
        return result;
    }

    abstract @UnknownKeyFor @NonNull @Initialized Type createPropertyType(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized Type getIdentifierType() {
        return MockSessionFactory.typeConfiguration.getBasicTypeForJavaType(Long.class);
    }

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierPropertyName() {
        return "id";
    }

    public @UnknownKeyFor @NonNull @Initialized Type toType(@UnknownKeyFor @NonNull @Initialized String propertyName) throws @UnknownKeyFor @NonNull @Initialized QueryException {
        Type type = this.getPropertyType(propertyName);
        if (type == null) {
            throw new QueryException(this.getEntityName() + " has no mapped " + propertyName);
        }
        return type;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRootEntityName() {
        for (MockEntityPersister persister : this.factory.getMockEntityPersisters()) {
            if (this == persister || !persister.isSubclassPersister(this)) continue;
            return persister.getRootEntityName();
        }
        return this.entityName;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubclassEntityNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(this.entityName);
        for (MockEntityPersister persister : this.factory.getMockEntityPersisters()) {
            if (!persister.isSubclassPersister(this)) continue;
            names.add(persister.entityName);
        }
        return names;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Queryable.Declarer getSubclassPropertyDeclarer(@UnknownKeyFor @NonNull @Initialized String s) {
        return Queryable.Declarer.CLASS;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] toColumns(@UnknownKeyFor @NonNull @Initialized String propertyName) {
        return new String[]{""};
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getPropertySpaces() {
        return new String[]{this.entityName};
    }

    public @UnknownKeyFor @NonNull @Initialized Serializable @UnknownKeyFor @NonNull @Initialized [] getQuerySpaces() {
        return new Serializable[]{this.entityName};
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityPersister() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getKeyColumnNames() {
        return this.getIdentifierColumnNames();
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getIdentifierColumnNames() {
        return ID_COLUMN;
    }

    public @UnknownKeyFor @NonNull @Initialized DiscriminatorMetadata getTypeDiscriminatorMetadata() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getResolutionType() {
        return MockSessionFactory.typeConfiguration.getBasicTypeForJavaType(Class.class);
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableName() {
        return this.entityName;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "MockEntityPersister[" + this.entityName + "]";
    }

    public @UnknownKeyFor @NonNull @Initialized int getVersionProperty() {
        return -66;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMappedSuperclass() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consumesEntityAlias() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getDiscriminatorType() {
        return MockSessionFactory.typeConfiguration.getBasicTypeForJavaType(String.class);
    }
}

