/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.JPAMetaModelEntityProcessor;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.TypeUtils;

public final class ClassWriter {
    private static final @UnknownKeyFor @NonNull @Initialized String META_MODEL_CLASS_NAME_SUFFIX = "_";

    private ClassWriter() {
    }

    public static void writeFile(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            String body = ClassWriter.generateBody(entity, context).toString();
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(ClassWriter.getFullyQualifiedClassName(entity, metaModelPackage), entity.getElement());
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            if (!metaModelPackage.isEmpty()) {
                pw.println("package " + metaModelPackage + ";");
                pw.println();
            }
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ": " + ioEx.getMessage());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized StringBuffer generateBody(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            if (context.addDependentAnnotation() && entity.isInjectable()) {
                pw.println(ClassWriter.writeDependentAnnotation(entity));
            }
            if (entity.getElement() instanceof TypeElement) {
                pw.println(ClassWriter.writeStaticMetaModelAnnotation(entity));
            }
            if (context.addGeneratedAnnotation()) {
                pw.println(ClassWriter.writeGeneratedAnnotation(entity, context));
            }
            if (context.isAddSuppressWarningsAnnotation()) {
                pw.println(ClassWriter.writeSuppressWarnings());
            }
            ClassWriter.printClassDeclaration(entity, pw, context);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasTypedAttribute()) continue;
                metaMember.getAttributeDeclarationString().lines().forEach(line -> pw.println("\t" + line));
            }
            pw.println();
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasStringAttribute()) continue;
                pw.println("\t" + metaMember.getAttributeNameDeclarationString());
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
    }

    private static void printClassDeclaration(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized PrintWriter pw, @UnknownKeyFor @NonNull @Initialized Context context) {
        pw.print(entity.isImplementation() ? "public class " : "public abstract class ");
        pw.print(entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX);
        String superClassName = ClassWriter.findMappedSuperClass(entity, context);
        if (superClassName != null) {
            pw.print(" extends " + superClassName + META_MODEL_CLASS_NAME_SUFFIX);
        }
        if (entity.isImplementation()) {
            pw.print(entity.getElement().getKind() == ElementKind.CLASS ? " extends " : " implements ");
            pw.print(entity.getSimpleName());
        }
        pw.println(" {");
    }

    private static @Nullable @UnknownKeyFor @Initialized String findMappedSuperClass(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        Element element = entity.getElement();
        if (element instanceof TypeElement) {
            TypeMirror superClass = ((TypeElement)element).getSuperclass();
            while (superClass.getKind() == TypeKind.DECLARED) {
                Element superClassElement = ((DeclaredType)superClass).asElement();
                String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
                if (ClassWriter.extendsSuperMetaModel(superClassElement, entity.isMetaComplete(), context)) {
                    return superClassName;
                }
                superClass = ((TypeElement)superClassElement).getSuperclass();
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean extendsSuperMetaModel(@UnknownKeyFor @NonNull @Initialized Element superClassElement, @UnknownKeyFor @NonNull @Initialized boolean entityMetaComplete, @UnknownKeyFor @NonNull @Initialized Context context) {
        String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
        if (context.containsMetaEntity(superClassName) || context.containsMetaEmbeddable(superClassName)) {
            return true;
        }
        return !entityMetaComplete && TypeUtils.containsAnnotation(superClassElement, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass");
    }

    private static @UnknownKeyFor @NonNull @Initialized String getFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized String metaModelPackage) {
        Object fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = (String)fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = (String)fullyQualifiedClassName + entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX;
        return fullyQualifiedClassName;
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeGeneratedAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        generatedAnnotation.append("@").append(entity.importType("jakarta.annotation.Generated")).append("(");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("value = ");
        }
        generatedAnnotation.append("\"").append(JPAMetaModelEntityProcessor.class.getName()).append("\"");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append(", date = ").append("\"").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now())).append("\"");
        }
        generatedAnnotation.append(")");
        return generatedAnnotation.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeSuppressWarnings() {
        return "@SuppressWarnings({ \"deprecation\", \"rawtypes\" })";
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeDependentAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        return "@" + entity.importType("jakarta.enterprise.context.Dependent");
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeStaticMetaModelAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        return "@" + entity.importType("jakarta.persistence.metamodel.StaticMetamodel") + "(" + entity.getSimpleName() + ".class)";
    }
}

