/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.ListCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.ListProxy;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.envers.tools.Pair;
import org.hibernate.persister.collection.CollectionPersister;

public final class ListCollectionMapper
extends AbstractCollectionMapper<List>
implements PropertyMapper {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ListCollectionMapper(Configuration configuration, CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData, boolean revisionTypeInId) {
        super(configuration, commonCollectionMapperData, List.class, ListProxy.class, false, revisionTypeInId);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<List> getInitializor(EnversService enversService, AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        return new ListCollectionInitializor(enversService, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, removed, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return Tools.listToIndexElementPairList((List)newCollection);
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return Tools.listToIndexElementPairList((List)((Object)oldCollection));
    }

    @Override
    protected void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object changed) {
        Pair indexValuePair = (Pair)changed;
        this.elementComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, indexValuePair.getSecond());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, indexValuePair.getFirst());
    }

    @Override
    protected Set<Object> buildCollectionChangeSet(Object eventCollection, Collection collection) {
        HashSet<Object> changeSet = new HashSet<Object>();
        if (eventCollection != null) {
            for (Object entry : collection) {
                Pair pair;
                if (entry == null || (pair = (Pair)Pair.class.cast(entry)).getSecond() == null) continue;
                changeSet.add(entry);
            }
        }
        return changeSet;
    }

    @Override
    protected List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Object id) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        CollectionPersister collectionPersister = this.resolveCollectionPersister(session, newColl);
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        Set<Object> addedElements = this.buildCollectionChangeSet(newColl, newCollection);
        if (oldColl != null) {
            block0: for (int i = 0; i < oldCollection.size(); ++i) {
                Pair oldEntry = (Pair)((List)oldCollection).get(i);
                Iterator<Object> itor = addedElements.iterator();
                while (itor.hasNext()) {
                    Pair addedEntry = (Pair)itor.next();
                    if (!((Integer)oldEntry.getFirst()).equals(addedEntry.getFirst()) || !this.isSame(collectionPersister, oldEntry.getSecond(), addedEntry.getSecond())) continue;
                    itor.remove();
                    continue block0;
                }
            }
        }
        Set<Object> deleteElements = this.buildCollectionChangeSet(oldColl, oldCollection);
        if (newColl != null) {
            block2: for (int i = 0; i < newCollection.size(); ++i) {
                Pair newEntry = (Pair)((List)newCollection).get(i);
                Iterator<Object> itor = deleteElements.iterator();
                while (itor.hasNext()) {
                    Pair deletedEntry = (Pair)itor.next();
                    if (!((Integer)newEntry.getFirst()).equals(deletedEntry.getFirst()) || !this.isSame(collectionPersister, deletedEntry.getSecond(), newEntry.getSecond())) continue;
                    itor.remove();
                    continue block2;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, addedElements, RevisionType.ADD, id);
        this.addCollectionChanges(session, collectionChanges, deleteElements, RevisionType.DEL, id);
        return collectionChanges;
    }
}

