/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class TimesTenSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public TimesTenSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = AbstractSqlAstTranslator.LockStrategy.CLAUSE;
        if (this.getQueryPartStack().findCurrentFirst(part -> part instanceof QueryGroup ? part : null) != null) {
            if (Boolean.FALSE.equals(followOnLocking)) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported!");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        if (tableGroupJoin.getJoinType() != SqlAstJoinType.CROSS) {
            this.appendSql(tableGroupJoin.getJoinType().getText());
        }
        this.appendSql("join ");
        Object predicate = tableGroupJoin.getPredicate() == null ? new BooleanExpressionPredicate((Expression)new QueryLiteral((Object)true, (SqlExpressible)this.getBooleanType())) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderRowsToClause((QuerySpec)this.getQueryPartStack().getCurrent());
        super.visitSqlSelections(selectClause);
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }
}

