/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.PostgreSQLLegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.TemporalUnit;

public class PostgresPlusLegacyDialect
extends PostgreSQLLegacyDialect {
    public PostgresPlusLegacyDialect() {
    }

    public PostgresPlusLegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    public PostgresPlusLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.systimestamp();
    }

    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "to_char(?1,'YYYY-MM-DD')";
                }
                case TIME: {
                    return "to_char(?1,'HH24:MI:SS')";
                }
                case TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                }
                case OFFSET_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                }
                case ZONE_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String currentTimestamp() {
        return "current_timestamp";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            return super.timestampdiffPattern(unit, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP);
        }
        return super.timestampdiffPattern(unit, fromTemporalType, toTemporalType);
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public String getSelectGUIDString() {
        return "select uuid_generate_v1";
    }
}

