/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Objects;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.ArrayTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class ArrayTypeDetailsImpl
implements ArrayTypeDetails {
    private final ClassDetails arrayClassDetails;
    private final TypeDetails constituentType;
    private final int dimensions;

    public ArrayTypeDetailsImpl(ClassDetails arrayClassDetails, TypeDetails constituentType) {
        this.arrayClassDetails = arrayClassDetails;
        this.constituentType = constituentType;
        this.dimensions = StringHelper.countArrayDimensions(arrayClassDetails.getName());
    }

    @Override
    public ClassDetails getArrayClassDetails() {
        return this.arrayClassDetails;
    }

    @Override
    public TypeDetails getConstituentType() {
        return this.constituentType;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getName() {
        return this.arrayClassDetails.getName();
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        if (ClassDetails.OBJECT_CLASS_DETAILS.isImplementor(checkType)) {
            return true;
        }
        if (!checkType.isArray()) {
            return false;
        }
        return this.constituentType.isImplementor(checkType.getComponentType());
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        if (this.constituentType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
            return this.constituentType.asParameterizedType().resolveTypeVariable(typeVariable);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTypeDetailsImpl that = (ArrayTypeDetailsImpl)o;
        return Objects.equals(this.arrayClassDetails, that.arrayClassDetails);
    }

    public int hashCode() {
        return Objects.hash(this.arrayClassDetails);
    }
}

