/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SharedAnnotationScope;

public interface SharedNamedAnnotationScope
extends SharedAnnotationScope {
    default public <X extends Annotation> X getNamedAnnotation(AnnotationDescriptor<X> annotationDescriptor, String matchName) {
        return this.getNamedAnnotation(annotationDescriptor, matchName, "name");
    }

    default public <A extends Annotation> A getNamedAnnotation(AnnotationDescriptor<A> annotationDescriptor, String matchName, String attributeToMatch) {
        List<A> allUsages = this.getAllAnnotationUsages(annotationDescriptor);
        AttributeDescriptor matchAttribute = annotationDescriptor.getAttribute(attributeToMatch);
        for (int i = 0; i < allUsages.size(); ++i) {
            Annotation annotationUsage = (Annotation)allUsages.get(i);
            String usageName = (String)AnnotationHelper.extractValue(annotationUsage, matchAttribute);
            if (!Objects.equals(matchName, usageName)) continue;
            return (A)annotationUsage;
        }
        return null;
    }
}

