/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.models.internal.RenderingCollectorImpl;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;

public interface AnnotationTarget {
    public Kind getKind();

    public String getName();

    public Collection<? extends Annotation> getDirectAnnotationUsages();

    default public void forEachDirectAnnotationUsage(Consumer<? extends Annotation> consumer) {
        this.getDirectAnnotationUsages().forEach(consumer);
    }

    public <A extends Annotation> boolean hasDirectAnnotationUsage(Class<A> var1);

    public <A extends Annotation> A getDirectAnnotationUsage(AnnotationDescriptor<A> var1);

    public <A extends Annotation> A getDirectAnnotationUsage(Class<A> var1);

    public <A extends Annotation> boolean hasAnnotationUsage(Class<A> var1, SourceModelBuildingContext var2);

    public <A extends Annotation> A getAnnotationUsage(AnnotationDescriptor<A> var1, SourceModelBuildingContext var2);

    default public <A extends Annotation> A getAnnotationUsage(Class<A> type, SourceModelBuildingContext modelContext) {
        return this.getAnnotationUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), modelContext);
    }

    public <A extends Annotation> A locateAnnotationUsage(Class<A> var1, SourceModelBuildingContext var2);

    public <A extends Annotation> A[] getRepeatedAnnotationUsages(AnnotationDescriptor<A> var1, SourceModelBuildingContext var2);

    default public <A extends Annotation> A[] getRepeatedAnnotationUsages(Class<A> type, SourceModelBuildingContext modelContext) {
        return this.getRepeatedAnnotationUsages(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), modelContext);
    }

    public <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(Class<A> var1, Class<C> var2, SourceModelBuildingContext var3, Consumer<A> var4);

    default public <A extends Annotation, C extends Annotation> void forEachRepeatedAnnotationUsages(AnnotationDescriptor<A> repeatable, SourceModelBuildingContext modelContext, Consumer<A> consumer) {
        if (!1.$assertionsDisabled && !repeatable.isRepeatable()) {
            throw new AssertionError();
        }
        this.forEachRepeatedAnnotationUsages(repeatable.getAnnotationType(), repeatable.getRepeatableContainer().getAnnotationType(), modelContext, consumer);
    }

    default public <X extends Annotation> void forEachAnnotationUsage(AnnotationDescriptor<X> type, SourceModelBuildingContext modelContext, Consumer<X> consumer) {
        Annotation[] annotations = this.getRepeatedAnnotationUsages(type, modelContext);
        if (annotations == null) {
            return;
        }
        for (Annotation annotation : annotations) {
            consumer.accept(annotation);
        }
    }

    default public <X extends Annotation> void forEachAnnotationUsage(Class<X> type, SourceModelBuildingContext modelContext, Consumer<X> consumer) {
        this.forEachAnnotationUsage(modelContext.getAnnotationDescriptorRegistry().getDescriptor(type), modelContext, consumer);
    }

    public <A extends Annotation> List<? extends Annotation> getMetaAnnotated(Class<A> var1, SourceModelBuildingContext var2);

    default public <X extends Annotation> X getNamedAnnotationUsage(AnnotationDescriptor<X> type, String matchName, SourceModelBuildingContext modelContext) {
        return this.getNamedAnnotationUsage(type, matchName, "name", modelContext);
    }

    default public <X extends Annotation> X getNamedAnnotationUsage(Class<X> type, String matchName, SourceModelBuildingContext modelContext) {
        return this.getNamedAnnotationUsage(type, matchName, "name", modelContext);
    }

    public <X extends Annotation> X getNamedAnnotationUsage(AnnotationDescriptor<X> var1, String var2, String var3, SourceModelBuildingContext var4);

    public <X extends Annotation> X getNamedAnnotationUsage(Class<X> var1, String var2, String var3, SourceModelBuildingContext var4);

    default public <T, A extends Annotation> T fromAnnotations(Class<A> annotationType, AnnotationUsageProcessor<T, A> processor, SourceModelBuildingContext modelContext) {
        Annotation[] annotationUsages;
        for (Annotation annotationUsage : annotationUsages = this.getRepeatedAnnotationUsages(annotationType, modelContext)) {
            T result = processor.process(annotationUsage);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor();

    public ClassDetails asClassDetails();

    public MemberDetails asMemberDetails();

    public FieldDetails asFieldDetails();

    public MethodDetails asMethodDetails();

    public RecordComponentDetails asRecordComponentDetails();

    public void render(SourceModelBuildingContext var1);

    default public String renderToString(SourceModelBuildingContext modelContext) {
        RenderingCollectorImpl renderingCollector = new RenderingCollectorImpl();
        this.render(renderingCollector, modelContext);
        return renderingCollector.toString();
    }

    public void render(RenderingCollector var1, SourceModelBuildingContext var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    @FunctionalInterface
    public static interface AnnotationUsageProcessor<T, A extends Annotation> {
        public T process(A var1);
    }

    public static enum Kind {
        ANNOTATION(ElementType.ANNOTATION_TYPE),
        CLASS(ElementType.TYPE),
        FIELD(ElementType.FIELD),
        METHOD(ElementType.METHOD),
        RECORD_COMPONENT(ElementType.RECORD_COMPONENT),
        PACKAGE(ElementType.PACKAGE);

        private final ElementType elementType;

        private Kind(ElementType elementType) {
            this.elementType = elementType;
        }

        public ElementType getCorrespondingElementType() {
            return this.elementType;
        }

        public static EnumSet<Kind> from(Target target) {
            if (target == null) {
                return EnumSet.allOf(Kind.class);
            }
            return Kind.from(target.value());
        }

        public static EnumSet<Kind> from(ElementType[] elementTypes) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            Kind[] values = Kind.values();
            for (int i = 0; i < elementTypes.length; ++i) {
                for (int v = 0; v < values.length; ++v) {
                    if (!values[v].getCorrespondingElementType().equals((Object)elementTypes[i])) continue;
                    kinds.add(values[v]);
                }
            }
            return kinds;
        }

        public static Kind from(ElementType elementType) {
            Kind[] values = Kind.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getCorrespondingElementType().equals((Object)elementType)) continue;
                return values[i];
            }
            return null;
        }
    }
}

