/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jandex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.jandex.AbstractAnnotationTarget;
import org.hibernate.models.internal.jandex.JandexTypeSwitchStandard;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;

public class JandexRecordComponentDetails
extends AbstractAnnotationTarget
implements RecordComponentDetails,
MutableMemberDetails {
    private final RecordComponentInfo recordComponentInfo;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final boolean isArray;
    private final boolean isPlural;

    public JandexRecordComponentDetails(RecordComponentInfo recordComponentInfo, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.recordComponentInfo = recordComponentInfo;
        this.declaringType = declaringType;
        this.type = JandexTypeSwitchStandard.switchType(recordComponentInfo.type(), declaringType, buildingContext);
        this.isArray = recordComponentInfo.type().kind() == Type.Kind.ARRAY;
        this.isPlural = this.isArray || this.type.isImplementor(Collection.class) || this.type.isImplementor(Map.class);
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.recordComponentInfo;
    }

    @Override
    public String getName() {
        return this.recordComponentInfo.name();
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public int getModifiers() {
        return this.recordComponentInfo.accessor().flags();
    }

    @Override
    public Member toJavaMember() {
        return null;
    }

    public String toString() {
        return "JandexFieldDetails(" + this.getName() + ")";
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        return this;
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    @Override
    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as FieldDetails");
    }

    @Override
    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast as FieldDetails");
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast to an AnnotationDescriptor");
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("RecordComponentDetails cannot be cast to a ClassDetails");
    }
}

