/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Locale;
import org.hibernate.models.internal.AbstractTypeDescriptor;
import org.hibernate.models.internal.jandex.JandexNestedValueConverter;
import org.hibernate.models.internal.jandex.JandexNestedValueExtractor;
import org.hibernate.models.internal.jdk.JdkNestedValueConverter;
import org.hibernate.models.internal.jdk.JdkNestedValueExtractor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.JandexValueConverter;
import org.hibernate.models.spi.JandexValueExtractor;
import org.hibernate.models.spi.JdkValueConverter;
import org.hibernate.models.spi.JdkValueExtractor;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class NestedTypeDescriptor<A extends Annotation>
extends AbstractTypeDescriptor<A> {
    private final Class<A> annotationType;
    private AnnotationDescriptor<A> descriptor;
    private JandexNestedValueConverter<A> jandexConverter;
    private JandexNestedValueExtractor<A> jandexExtractor;
    private JdkNestedValueConverter<A> jdkConverter;
    private JdkNestedValueExtractor<A> jdkExtractor;

    public NestedTypeDescriptor(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Class<A> getValueType() {
        return this.annotationType;
    }

    private AnnotationDescriptor<A> resolveDescriptor(SourceModelBuildingContext context) {
        if (this.descriptor == null) {
            this.descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(this.annotationType);
        }
        return this.descriptor;
    }

    @Override
    public JandexValueConverter<A> createJandexValueConverter(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexWrapper(buildingContext);
    }

    public JandexNestedValueConverter<A> resolveJandexWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jandexConverter == null) {
            this.jandexConverter = new JandexNestedValueConverter<A>(this.resolveDescriptor(buildingContext));
        }
        return this.jandexConverter;
    }

    @Override
    public JandexValueExtractor<A> createJandexValueExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexExtractor(buildingContext);
    }

    public JandexNestedValueExtractor<A> resolveJandexExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jandexExtractor == null) {
            this.jandexExtractor = new JandexNestedValueExtractor<A>(this.resolveJandexWrapper(buildingContext));
        }
        return this.jandexExtractor;
    }

    @Override
    public JdkValueConverter<A> createJdkValueConverter(SourceModelBuildingContext modelContext) {
        return this.resolveJdkValueConverter(modelContext);
    }

    public JdkNestedValueConverter<A> resolveJdkValueConverter(SourceModelBuildingContext modelContext) {
        if (this.jdkConverter == null) {
            this.jdkConverter = new JdkNestedValueConverter<A>(this.resolveDescriptor(modelContext));
        }
        return this.jdkConverter;
    }

    @Override
    public JdkValueExtractor<A> createJdkValueExtractor(SourceModelBuildingContext modelContext) {
        return this.resolveJdkValueExtractor(modelContext);
    }

    public JdkValueExtractor<A> resolveJdkValueExtractor(SourceModelBuildingContext modelContext) {
        if (this.jdkExtractor == null) {
            this.jdkExtractor = new JdkNestedValueExtractor<A>(this.resolveJdkValueConverter(modelContext));
        }
        return this.jdkExtractor;
    }

    @Override
    public Object unwrap(A value) {
        return value;
    }

    @Override
    public void render(RenderingCollector collector, String name, Object attributeValue, SourceModelBuildingContext modelContext) {
        this.resolveDescriptor(modelContext).renderUsage(collector, name, (Annotation)attributeValue, modelContext);
    }

    @Override
    public void render(RenderingCollector collector, Object attributeValue, SourceModelBuildingContext modelContext) {
        this.resolveDescriptor(modelContext).renderUsage(collector, (Annotation)attributeValue, modelContext);
    }

    @Override
    public A[] makeArray(int size, SourceModelBuildingContext modelContext) {
        return (Annotation[])Array.newInstance(this.resolveDescriptor(modelContext).getAnnotationType(), size);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "AttributeTypeDescriptor(%s)", this.descriptor.getAnnotationType().getName());
    }
}

