/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.models.internal.AttributeDescriptorImpl;
import org.hibernate.models.internal.jandex.ArrayValueConverter;
import org.hibernate.models.internal.jandex.ArrayValueExtractor;
import org.hibernate.models.internal.jdk.JdkArrayValueConverter;
import org.hibernate.models.internal.jdk.JdkArrayValueExtractor;
import org.hibernate.models.internal.jdk.JdkPassThruConverter;
import org.hibernate.models.internal.jdk.JdkPassThruExtractor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.JandexValueConverter;
import org.hibernate.models.spi.JandexValueExtractor;
import org.hibernate.models.spi.JdkValueConverter;
import org.hibernate.models.spi.JdkValueExtractor;
import org.hibernate.models.spi.RenderingCollector;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class ArrayTypeDescriptor<V>
implements ValueTypeDescriptor<V[]> {
    private final ValueTypeDescriptor<V> elementTypeDescriptor;
    private final Class<V> componentType;
    private final Class<V[]> arrayType;
    private JandexValueConverter<V[]> jandexValueConverter;
    private JandexValueExtractor<V[]> jandexValueExtractor;
    private JdkValueConverter<V[]> jdkValueConverter;
    private JdkValueExtractor<V[]> jdkValueExtractor;

    public ArrayTypeDescriptor(ValueTypeDescriptor<V> elementTypeDescriptor) {
        this.elementTypeDescriptor = elementTypeDescriptor;
        this.componentType = elementTypeDescriptor.getValueType();
        this.arrayType = this.componentType.arrayType();
    }

    public ValueTypeDescriptor<V> getElementTypeDescriptor() {
        return this.elementTypeDescriptor;
    }

    @Override
    public Class<V[]> getValueType() {
        return this.arrayType;
    }

    @Override
    public AttributeDescriptor<V[]> createAttributeDescriptor(Class<? extends Annotation> annotationType, String attributeName) {
        return new AttributeDescriptorImpl<V[]>(annotationType, attributeName, this);
    }

    @Override
    public JandexValueExtractor<V[]> createJandexValueExtractor(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexExtractor(buildingContext);
    }

    public JandexValueExtractor<V[]> resolveJandexExtractor(SourceModelBuildingContext buildingContext) {
        if (this.jandexValueExtractor == null) {
            this.jandexValueExtractor = new ArrayValueExtractor(this.resolveJandexWrapper(buildingContext));
        }
        return this.jandexValueExtractor;
    }

    @Override
    public JandexValueConverter<V[]> createJandexValueConverter(SourceModelBuildingContext buildingContext) {
        return this.resolveJandexWrapper(buildingContext);
    }

    private JandexValueConverter<V[]> resolveJandexWrapper(SourceModelBuildingContext buildingContext) {
        if (this.jandexValueConverter == null) {
            this.jandexValueConverter = new ArrayValueConverter<V>(this.elementTypeDescriptor);
        }
        return this.jandexValueConverter;
    }

    @Override
    public JdkValueConverter<V[]> createJdkValueConverter(SourceModelBuildingContext modelContext) {
        if (this.jdkValueConverter == null) {
            this.jdkValueConverter = !this.elementTypeDescriptor.getValueType().isAnnotation() ? JdkPassThruConverter.passThruConverter() : new JdkArrayValueConverter<V>(this.elementTypeDescriptor);
        }
        return this.jdkValueConverter;
    }

    @Override
    public JdkValueExtractor<V[]> createJdkValueExtractor(SourceModelBuildingContext modelContext) {
        if (this.jdkValueExtractor == null) {
            this.jdkValueExtractor = !this.elementTypeDescriptor.getValueType().isAnnotation() ? JdkPassThruExtractor.passThruExtractor() : new JdkArrayValueExtractor(this.createJdkValueConverter(modelContext));
        }
        return this.jdkValueExtractor;
    }

    @Override
    public Object unwrap(V[] value) {
        Object[] result = (Object[])Array.newInstance(this.componentType, value.length);
        for (int i = 0; i < value.length; ++i) {
            result[i] = this.elementTypeDescriptor.unwrap(value[i]);
        }
        return result;
    }

    @Override
    public void render(RenderingCollector collector, String name, Object attributeValue, SourceModelBuildingContext modelContext) {
        assert (attributeValue != null) : "Annotation value was null - " + name;
        Object[] values = (Object[])attributeValue;
        collector.addLine("%s = {", name);
        collector.indent(2);
        for (Object value : values) {
            this.elementTypeDescriptor.render(collector, value, modelContext);
        }
        collector.unindent(2);
        collector.addLine("}");
    }

    @Override
    public void render(RenderingCollector collector, Object attributeValue, SourceModelBuildingContext modelContext) {
        List values = (List)attributeValue;
        collector.addLine("{");
        collector.indent(2);
        values.forEach(value -> this.elementTypeDescriptor.render(collector, value, modelContext));
        collector.unindent(2);
        collector.addLine("}");
    }

    public V[][] makeArray(int size, SourceModelBuildingContext modelContext) {
        throw new UnsupportedOperationException("Nested array creation not supported");
    }
}

