/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.util.Set;
import javax.validation.metadata.GroupConversionDescriptor;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IterableAssert;

public class DescriptorAssert {
    private DescriptorAssert() {
    }

    public static GroupConversionDescriptorSetAssert assertThat(Set<GroupConversionDescriptor> groupConversions) {
        return new GroupConversionDescriptorSetAssert(groupConversions);
    }

    public static class GroupConversionDescriptorSetAssert
    extends IterableAssert<GroupConversionDescriptor> {
        protected GroupConversionDescriptorSetAssert(Set<GroupConversionDescriptor> actual) {
            super(actual);
        }

        public void containsConversion(Class<?> from, Class<?> to) {
            this.isNotNull();
            boolean foundMatchingConversion = false;
            for (GroupConversionDescriptor groupConversionDescriptor : (Iterable)this.actual) {
                if (!groupConversionDescriptor.getFrom().equals(from) || !groupConversionDescriptor.getTo().equals(to)) continue;
                foundMatchingConversion = true;
                break;
            }
            if (!foundMatchingConversion) {
                Fail.fail((String)String.format("<%s> does not contain a conversion from <%s> to <%s>.", this.actual, from, to));
            }
        }
    }
}

