/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IterableAssert;
import org.testng.Assert;

public final class ConstraintViolationAssert {
    private static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";
    private static final String RETURN_VALUE_NODE_NAME = "<return value>";

    private ConstraintViolationAssert() {
    }

    public static void assertCorrectConstraintViolationMessages(Set<? extends ConstraintViolation<?>> violations, String ... expectedMessages) {
        ArrayList<String> actualMessages = new ArrayList<String>();
        for (ConstraintViolation<?> violation : violations) {
            actualMessages.add(violation.getMessage());
        }
        Assertions.assertThat(actualMessages).containsOnly((Object[])expectedMessages);
    }

    public static void assertCorrectConstraintViolationMessages(ConstraintViolationException e, String ... expectedMessages) {
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(e.getConstraintViolations(), expectedMessages);
    }

    public static void assertCorrectConstraintTypes(Set<? extends ConstraintViolation<?>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintViolation<?> violation : violations) {
            actualConstraintTypes.add(violation.getConstraintDescriptor().getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertCorrectPropertyPaths(Set<? extends ConstraintViolation<?>> violations, String ... expectedPropertyPaths) {
        List<String> expectedPathsAsList = Arrays.asList(expectedPropertyPaths);
        ArrayList<String> actualPaths = new ArrayList<String>();
        for (ConstraintViolation<?> violation : violations) {
            actualPaths.add(violation.getPropertyPath().toString());
        }
        Collections.sort(expectedPathsAsList);
        Collections.sort(actualPaths);
        Assert.assertEquals(actualPaths, expectedPathsAsList, (String)String.format("Expected %s, but got %s", expectedPathsAsList, actualPaths));
    }

    public static ConstraintViolationSetAssert assertThat(Set<? extends ConstraintViolation<?>> actualViolations) {
        return new ConstraintViolationSetAssert(actualViolations);
    }

    public static void assertCorrectPropertyPaths(ConstraintViolationException e, String ... expectedPropertyPaths) {
        ConstraintViolationAssert.assertCorrectPropertyPaths(e.getConstraintViolations(), expectedPropertyPaths);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue, String propertyPath) {
        Assert.assertTrue((boolean)ConstraintViolationAssert.pathsAreEqual(violation.getPropertyPath(), PathImpl.createNewPath(propertyPath)), (String)"Wrong propertyPath");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass, invalidValue);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue) {
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)invalidValue, (String)"Wrong invalid value");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass) {
        Assert.assertEquals(violation.getRootBean().getClass(), rootBeanClass, (String)"Wrong root bean type");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage) {
        Assert.assertEquals((String)violation.getMessage(), (String)errorMessage, (String)"Wrong expectedMessage");
    }

    public static void assertNumberOfViolations(Set<? extends ConstraintViolation<?>> violations, int numberOfViolations) {
        Assert.assertEquals((int)violations.size(), (int)numberOfViolations, (String)"Wrong number of constraint violations");
    }

    public static void assertConstraintTypes(Set<? extends ConstraintDescriptor<?>> descriptors, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintDescriptor<?> descriptor : descriptors) {
            actualConstraintTypes.add(descriptor.getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertNodeKinds(Path path, ElementKind ... kinds) {
        Iterator pathIterator = path.iterator();
        for (ElementKind kind : kinds) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((Object)((Path.Node)pathIterator.next()).getKind(), (Object)kind);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static void assertNodeNames(Path path, String ... names) {
        Iterator pathIterator = path.iterator();
        for (String name : names) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((String)((Path.Node)pathIterator.next()).getName(), (String)name);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static boolean pathsAreEqual(Path p1, Path p2) {
        Iterator p1Iterator = p1.iterator();
        Iterator p2Iterator = p2.iterator();
        while (p1Iterator.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iterator.next();
            if (!p2Iterator.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iterator.next();
            if (p2Node.getName() == null ? p1Node.getName() != null : !p2Node.getName().equals(p1Node.getName())) {
                return false;
            }
            if (p2Node.isInIterable() != p1Node.isInIterable()) {
                return false;
            }
            if (p2Node.getIndex() == null ? p1Node.getIndex() != null : !p2Node.getIndex().equals(p1Node.getIndex())) {
                return false;
            }
            if (!(p2Node.getKey() == null ? p1Node.getKey() != null : !p2Node.getKey().equals(p1Node.getKey()))) continue;
            return false;
        }
        return !p2Iterator.hasNext();
    }

    private static <T> void assertCorrectConstraintTypes(Iterable<Class<? extends Annotation>> actualConstraintTypes, Class<?> ... expectedConstraintTypes) {
        ArrayList<String> expectedConstraintTypeNames = new ArrayList<String>();
        for (Class<?> expectedConstraintType : expectedConstraintTypes) {
            expectedConstraintTypeNames.add(expectedConstraintType.getName());
        }
        ArrayList<String> actualConstraintTypeNames = new ArrayList<String>();
        for (Class<? extends Annotation> actualConstraintType : actualConstraintTypes) {
            actualConstraintTypeNames.add(actualConstraintType.getName());
        }
        Collections.sort(expectedConstraintTypeNames);
        Collections.sort(actualConstraintTypeNames);
        Assert.assertEquals(actualConstraintTypeNames, expectedConstraintTypeNames, (String)String.format("Expected %s, but got %s", expectedConstraintTypeNames, actualConstraintTypeNames));
    }

    public static PathExpectation pathWith() {
        return new PathExpectation();
    }

    public static class NodeImpl
    implements Path.Node {
        private final String name;
        private boolean isInIterable;
        private Integer index;
        private Object key;

        public NodeImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return this.isInIterable;
        }

        public void setInIterable(boolean inIterable) {
            this.isInIterable = inIterable;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.isInIterable = true;
            this.index = index;
        }

        public Object getKey() {
            return this.key;
        }

        public ElementKind getKind() {
            throw new UnsupportedOperationException();
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException();
        }

        public void setKey(Object key) {
            this.isInIterable = true;
            this.key = key;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NodeImpl");
            sb.append("{index=").append(this.index);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", isInIterable=").append(this.isInIterable);
            sb.append(", key=").append(this.key);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class PathImpl
    implements Path {
        private static final Pattern pathPattern = Pattern.compile("(\\w+)(\\[(\\w*)\\])?(\\.(.*))*");
        private static final int PROPERTY_NAME_GROUP = 1;
        private static final int INDEXED_GROUP = 2;
        private static final int INDEX_GROUP = 3;
        private static final int REMAINING_STRING_GROUP = 5;
        private static final String PROPERTY_PATH_SEPARATOR = ".";
        private static final String INDEX_OPEN = "[";
        private static final String INDEX_CLOSE = "]";
        private final List<Path.Node> nodeList = new ArrayList<Path.Node>();

        public static PathImpl createPathFromString(String propertyPath) {
            if (propertyPath == null) {
                throw new IllegalArgumentException("null is not allowed as property path.");
            }
            if (propertyPath.length() == 0) {
                return PathImpl.createNewPath(null);
            }
            return PathImpl.parseProperty(propertyPath);
        }

        public static PathImpl createNewPath(String name) {
            PathImpl path = new PathImpl();
            NodeImpl node = new NodeImpl(name);
            path.addNode(node);
            return path;
        }

        private PathImpl() {
        }

        public void addNode(Path.Node node) {
            this.nodeList.add(node);
        }

        public Iterator<Path.Node> iterator() {
            return this.nodeList.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator<Path.Node> iter = this.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Path.Node node = iter.next();
                if (node.isInIterable()) {
                    this.appendIndex(builder, node);
                }
                if (node.getName() != null) {
                    if (!first) {
                        builder.append(PROPERTY_PATH_SEPARATOR);
                    }
                    builder.append(node.getName());
                }
                first = false;
            }
            return builder.toString();
        }

        private void appendIndex(StringBuilder builder, Path.Node node) {
            builder.append(INDEX_OPEN);
            if (node.getIndex() != null) {
                builder.append(node.getIndex());
            } else if (node.getKey() != null) {
                builder.append(node.getKey());
            }
            builder.append(INDEX_CLOSE);
        }

        private static PathImpl parseProperty(String property) {
            PathImpl path = new PathImpl();
            String tmp = property;
            boolean indexed = false;
            String indexOrKey = null;
            do {
                Matcher matcher;
                if ((matcher = pathPattern.matcher(tmp)).matches()) {
                    String value = matcher.group(1);
                    NodeImpl node = new NodeImpl(value);
                    path.addNode(node);
                    if (indexed) {
                        PathImpl.updateNodeIndexOrKey(indexOrKey, node);
                    }
                } else {
                    throw new IllegalArgumentException("Unable to parse property path " + property);
                }
                indexed = matcher.group(2) != null;
                indexOrKey = matcher.group(3);
                tmp = matcher.group(5);
            } while (tmp != null);
            if (indexed) {
                NodeImpl node = new NodeImpl(null);
                PathImpl.updateNodeIndexOrKey(indexOrKey, node);
                path.addNode(node);
            }
            return path;
        }

        private static void updateNodeIndexOrKey(String indexOrKey, NodeImpl node) {
            node.setInIterable(true);
            if (indexOrKey != null && indexOrKey.length() > 0) {
                try {
                    Integer i = Integer.parseInt(indexOrKey);
                    node.setIndex(i);
                }
                catch (NumberFormatException e) {
                    node.setKey(indexOrKey);
                }
            }
        }
    }

    private static class NodeExpectation {
        private final String name;
        private final ElementKind kind;
        private final boolean inIterable;
        private final Object key;
        private final Integer index;
        private final Integer parameterIndex;

        private NodeExpectation(String name, ElementKind kind) {
            this(name, kind, false, null, null, null);
        }

        private NodeExpectation(String name, ElementKind kind, boolean inIterable, Object key, Integer index, Integer parameterIndex) {
            this.name = name;
            this.kind = kind;
            this.inIterable = inIterable;
            this.key = key;
            this.index = index;
            this.parameterIndex = parameterIndex;
        }

        public String toString() {
            return "NodeExpectation(" + this.name + ", " + this.kind + ", " + this.inIterable + ", " + this.key + ", " + this.index + ", " + this.parameterIndex + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inIterable ? 1231 : 1237);
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExpectation other = (NodeExpectation)obj;
            if (this.inIterable != other.inIterable) {
                return false;
            }
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex));
        }
    }

    public static class PathExpectation {
        private final List<NodeExpectation> nodes = new ArrayList<NodeExpectation>();

        private PathExpectation() {
        }

        private PathExpectation(Path propertyPath) {
            for (Path.Node node : propertyPath) {
                Integer parameterIndex = null;
                if (node.getKind() == ElementKind.PARAMETER) {
                    parameterIndex = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                }
                this.nodes.add(new NodeExpectation(node.getName(), node.getKind(), node.isInIterable(), node.getKey(), node.getIndex(), parameterIndex));
            }
        }

        public PathExpectation property(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null));
            return this;
        }

        public PathExpectation bean() {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null));
            return this;
        }

        public PathExpectation method(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.METHOD));
            return this;
        }

        public PathExpectation parameter(String name, int index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PARAMETER, false, null, null, index));
            return this;
        }

        public PathExpectation crossParameter() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.CROSS_PARAMETER_NODE_NAME, ElementKind.CROSS_PARAMETER));
            return this;
        }

        public PathExpectation returnValue() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.RETURN_VALUE_NODE_NAME, ElementKind.RETURN_VALUE));
            return this;
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("  ").append(node).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathExpectation other = (PathExpectation)obj;
            return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
        }
    }

    public static class ConstraintViolationSetAssert
    extends IterableAssert<ConstraintViolation<?>> {
        protected ConstraintViolationSetAssert(Set<? extends ConstraintViolation<?>> actualViolations) {
            super(actualViolations);
        }

        public void containsOnlyPaths(PathExpectation ... paths) {
            this.isNotNull();
            List<PathExpectation> expectedPaths = Arrays.asList(paths);
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                actualPaths.add(new PathExpectation(violation.getPropertyPath()));
            }
            ArrayList actualPathsTmp = new ArrayList(actualPaths);
            actualPathsTmp.removeAll(expectedPaths);
            if (!actualPathsTmp.isEmpty()) {
                Fail.fail((String)String.format("Found unexpected path(s): <%s>. Expected: <%s>", actualPathsTmp, expectedPaths));
            }
            ArrayList<PathExpectation> expectedPathsTmp = new ArrayList<PathExpectation>(expectedPaths);
            expectedPathsTmp.removeAll(actualPaths);
            if (!expectedPathsTmp.isEmpty()) {
                Fail.fail((String)String.format("Missing expected path(s) <%s>. Actual paths: <%s>", expectedPathsTmp, actualPaths));
            }
        }

        public void containsPath(PathExpectation expectedPath) {
            this.isNotNull();
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                PathExpectation actual = new PathExpectation(violation.getPropertyPath());
                if (actual.equals(expectedPath)) {
                    return;
                }
                actualPaths.add(actual);
            }
            Fail.fail((String)String.format("Didn't find path <%s> in actual paths <%s>.", expectedPath, actualPaths));
        }

        public void containsPaths(PathExpectation ... expectedPaths) {
            for (PathExpectation pathExpectation : expectedPaths) {
                this.containsPath(pathExpectation);
            }
        }
    }
}

